package com.devplatform.admin.modules.sys.service.impl;

import com.devplatform.admin.modules.sys.bean.SysUserRoleEntity;
import com.devplatform.admin.modules.sys.dao.SysUserRoleDao;
import com.devplatform.admin.modules.sys.service.SysUserRoleService;
import com.devplatform.common.service.impl.MyBaseServiceImpl;
import com.devplatform.common.util.MapUtils;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/**
 * 用户与角色对应关系
 *
 * @author chenshun
 * @email sunlightcs@gmail.com
 * @date 2016年9月18日 上午9:45:48
 */
@Service("sysUserRoleService")
public class SysUserRoleServiceImpl extends MyBaseServiceImpl<SysUserRoleDao, SysUserRoleEntity>
    implements SysUserRoleService {

  @Override
  @Transactional(rollbackFor = Exception.class)
  public void saveOrUpdate(String userId, List<String> roleIdList) {
    // 先删除用户与角色关系
    this.removeByMap(new MapUtils().put("user_id", userId));

    if (roleIdList == null || roleIdList.size() == 0) {
      return;
    }

    // 保存用户与角色关系
    List<SysUserRoleEntity> list = new ArrayList<>(roleIdList.size());
    for (String roleId : roleIdList) {
      SysUserRoleEntity sysUserRoleEntity = new SysUserRoleEntity();
      sysUserRoleEntity.setUserId(userId);
      sysUserRoleEntity.setRoleId(roleId);

      list.add(sysUserRoleEntity);
    }
    this.saveBatch(list);
  }

  @Override
  public List<String> queryRoleIdList(String userId) {
    return baseMapper.queryRoleIdList(userId);
  }

  @Override
  public int deleteBatch(String[] roleIds) {
    return baseMapper.deleteBatch(roleIds);
  }
}
