package com.devplatform.admin.modules.sys.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.devplatform.admin.modules.sys.bean.SysUserEntity;
import com.devplatform.admin.modules.sys.dao.SysUserDao;
import com.devplatform.admin.modules.sys.model.SysUserModel;
import com.devplatform.admin.modules.sys.service.SysRoleService;
import com.devplatform.admin.modules.sys.service.SysUserRoleService;
import com.devplatform.admin.modules.sys.service.SysUserService;
import com.devplatform.common.base.exception.RRException;
import com.devplatform.common.service.impl.MyBaseServiceImpl;
import com.devplatform.common.util.Constant;
import com.devplatform.common.util.R;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.shiro.crypto.hash.Sha256Hash;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;

/**
 * 系统用户
 *
 * @author chenshun
 * @email sunlightcs@gmail.com
 * @date 2016年9月18日 上午9:46:09
 */
@Service("sysUserService")
public class SysUserServiceImpl extends MyBaseServiceImpl<SysUserDao, SysUserEntity>
        implements SysUserService {
    @Autowired
    private SysUserRoleService sysUserRoleService;
    @Autowired
    private SysRoleService sysRoleService;

    @Override
    public List<String> queryAllPerms(String userId) {
        return baseMapper.queryAllPerms(userId);
    }

    @Override
    public List<String> queryAllMenuId(String userId) {
        return baseMapper.queryAllMenuId(userId);
    }

    @Override
    public SysUserEntity queryByUserName(String username) {
        return baseMapper.queryByUserName(username);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public boolean save(SysUserEntity user) {
        checkUserName(user);
        user.setCreateTime(new Date());
        // sha256加密
        String salt = RandomStringUtils.randomAlphanumeric(20);
        user.setPassword(new Sha256Hash(user.getPassword(), salt).toHex());
        user.setSalt(salt);
        super.save(user);
        return true;
    }

    /**
     * 校验用户名
     *
     * @param user
     */
    public void checkUserName(SysUserEntity user) {
        String username = user.getUsername();
        if (StringUtils.isBlank(username)) {
            throw new RRException("用户名不能为空");
        }
        List<SysUserEntity> userEntityList =
                baseMapper.selectList(new QueryWrapper<SysUserEntity>().eq("username", username).eq("deleted", 0));
        for (SysUserEntity userEntity : userEntityList) {
            if (userEntity != null && !userEntity.getUserId().equals(user.getUserId())) {
                throw new RRException("用户帐号已存在");
            }
        }
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void update(SysUserEntity user) {
        checkUserName(user);
        user.setUpdateTime(new Date());
        this.updateById(user);
    }

    @Override
    public void deleteBatch(String[] userId, String sysSign) {
        ArrayList<SysUserEntity> list = new ArrayList<>();
        for (String s : userId) {
            SysUserEntity sysUserEntity = new SysUserEntity();
            sysUserEntity.setUserId(s);
            sysUserEntity.setUpdateTime(new Date());
            sysUserEntity.setSysSign(sysSign);
            // 逻辑删除
            sysUserEntity.setDeleted(1);
            list.add(sysUserEntity);
        }
        this.updateBatchById(list);
    }

    @Override
    public boolean updatePassword(
            String userId, String password, String newPassword, String sysSign) {
        SysUserEntity userEntity = new SysUserEntity();
        userEntity.setPassword(newPassword);
        userEntity.setSysSign(sysSign);
        return this.update(
                userEntity,
                new QueryWrapper<SysUserEntity>().eq("user_id", userId).eq("password", password));
    }

    /**
     * 检查角色是否越权
     */
    private void checkRole(SysUserEntity user) {
        if (user.getRoleIdList() == null || user.getRoleIdList().size() == 0) {
            return;
        }
        // 如果不是超级管理员，则需要判断用户的角色是否自己创建
        if (user.getCreateUserId() == Constant.SUPER_ADMIN) {
            return;
        }

        // 查询用户创建的角色列表
        List<String> roleIdList = sysRoleService.queryRoleIdList(user.getCreateUserId());

        // 判断是否越权
        if (!roleIdList.containsAll(user.getRoleIdList())) {
            throw new RRException("新增用户所选角色，不是本人创建");
        }
    }

    /**
     * 查询用户列表
     */
    @Override
    public Page<SysUserEntity> queryByList(Page<SysUserEntity> page, SysUserModel model) {
        return baseMapper.queryByList(page, model);
    }

    @Override
    public SysUserEntity getById(String userId) {
        // TODO Auto-generated method stub
        return baseMapper.getById(userId);
    }

    @Override
    public Integer queryUserById(SysUserEntity model) {
        // TODO Auto-generated method stub
        return baseMapper.queryUserById(model);
    }

    @Override
    public void updatePassword(String username, String password, String sysSign) {
        baseMapper.updatePassword(username, password, sysSign);
    }

    @Override
    public List<HashMap<String, Object>> getUserInfoByOrgId(String orgId) {
        return baseMapper.getUserInfoByOrgId(orgId);
    }

    @Override
    public R selectUserByOrgId(
            String orgId,
            String username,
            String name,
            String jobNumber,
            Integer gender,
            String status,
            String sort,
            String order,
            Integer page,
            Integer size,
            String stationId) {
        //        ArrayList<String> orgIds = new ArrayList<>();
        // 查询下一级
        //        List<String> child = getChild(orgId, orgIds);
        HashMap<String, Object> map = new HashMap<>(10);
        map.put("orgId", orgId);
        map.put("username", username);
        map.put("name", name);
        map.put("jobNumber", jobNumber);
        map.put("gender", gender);
        map.put("sort", sort);
        map.put("order", order);
        map.put("status", status);
        map.put("stationId", stationId);
        if (page != null && size != null) {
            // 分页查询
            Page<HashMap<String, Object>> result =
                    baseMapper.getAllUserByOrgIdPage(new Page<HashMap<String, Object>>(page, size), map);
            return R.ok().put("data", result);
        } else {
            // 不分页查询
            List<HashMap<String, Object>> result = baseMapper.getAllUserByOrgId(map);
            return R.ok().put("data", result);
        }
    }

    @Override
    public void updatePw(
            String[] split, String password, String salt, String userId, String sysSign) {
        baseMapper.updatePw(split, password, salt, userId, sysSign);
    }

    @Override
    public List<HashMap<String, Object>> getAllNation() {
        return baseMapper.getAllNation();
    }
}
