package com.devplatform.admin.modules.sys.service.impl;

import com.devplatform.admin.modules.sys.bean.SysUserTokenEntity;
import com.devplatform.admin.modules.sys.dao.SysUserTokenDao;
import com.devplatform.admin.modules.sys.oauth2.TokenGenerator;
import com.devplatform.admin.modules.sys.service.SysUserTokenService;
import com.devplatform.common.service.impl.MyBaseServiceImpl;
import com.devplatform.common.util.R;
import java.util.Date;
import org.springframework.stereotype.Service;
/**
 * @author Administrator
 */
@Service("sysUserTokenService")
public class SysUserTokenServiceImpl extends MyBaseServiceImpl<SysUserTokenDao, SysUserTokenEntity>
    implements SysUserTokenService {
  /** 12小时后过期 */
  private static final int EXPIRE = 3600 * 12;

  @Override
  public R createToken(String userId) {
    // 生成一个token
    String token = TokenGenerator.generateValue();

    // 当前时间
    Date now = new Date();
    // 过期时间
    Date expireTime = new Date(now.getTime() + EXPIRE * 1000);

    // 判断是否生成过token
    SysUserTokenEntity tokenEntity = this.getById(userId);
    if (tokenEntity == null) {
      tokenEntity = new SysUserTokenEntity();
      tokenEntity.setUserId(userId);
      tokenEntity.setToken(token);
      tokenEntity.setUpdateTime(now);
      tokenEntity.setExpireTime(expireTime);

      // 保存token
      this.save(tokenEntity);
    } else {
      tokenEntity.setToken(token);
      tokenEntity.setUpdateTime(now);
      tokenEntity.setExpireTime(expireTime);

      // 更新token
      this.updateById(tokenEntity);
    }

    R r = R.ok().put("token", token).put("expire", EXPIRE);

    return r;
  }

  @Override
  public R saveToken(String token, String userId) {
    // 当前时间
    Date now = new Date();
    // 过期时间
    Date expireTime = new Date(now.getTime() + EXPIRE * 1000);

    // 判断是否生成过token
    SysUserTokenEntity tokenEntity = this.getById(userId);
    if (tokenEntity == null) {
      tokenEntity = new SysUserTokenEntity();
      tokenEntity.setUserId(userId);
      tokenEntity.setToken(token);
      tokenEntity.setUpdateTime(now);
      tokenEntity.setExpireTime(expireTime);

      // 保存token
      this.save(tokenEntity);
    } else {
      tokenEntity.setToken(token);
      tokenEntity.setUpdateTime(now);
      tokenEntity.setExpireTime(expireTime);

      // 更新token
      this.updateById(tokenEntity);
    }

    R r = R.ok().put("token", token).put("expire", EXPIRE);

    return r;
  }

  @Override
  public void logout(String userId) {
    // 生成一个token
    String token = TokenGenerator.generateValue();

    // 修改token
    SysUserTokenEntity tokenEntity = new SysUserTokenEntity();
    tokenEntity.setUserId(userId);
    tokenEntity.setToken(token);
    this.updateById(tokenEntity);
  }
}
