package com.devplatform.admin.modules.sysdictionary.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.devplatform.admin.common.annotation.SysLogMethod;
import com.devplatform.admin.common.utils.AbstractController;
import com.devplatform.admin.common.utils.Constants;
import com.devplatform.admin.config.WebSocket;
import com.devplatform.admin.modules.sysdictionary.bean.SysDictionary;
import com.devplatform.admin.modules.sysdictionary.model.SysDictionaryModel;
import com.devplatform.admin.modules.sysdictionary.service.SysDictionaryService;
import com.devplatform.common.base.validator.ValidatorUtils;
import com.devplatform.common.util.PageUtils;
import com.devplatform.common.util.R;
import com.devplatform.common.util.StringUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.*;
/**
 * @author Administrator
 */
@Api(tags = {"数据字典表接口"})
@RestController
@RequestMapping("/sysDictionary")
public class SysDictionaryController extends AbstractController {
  @Autowired private SysDictionaryService sysDictionaryService;

  @Autowired private WebSocket webSocket;

  /**
   * 列表页面列表数据获取
   *
   * @param params 承接对象
   * @return
   */
  @ApiOperation(value = "根据条件获取数据字典表分页数据列表", notes = "根据条件获取数据字典表分页数据列表")
  @ApiImplicitParam(
      name = "params",
      value = "参数",
      required = true,
      dataType = "Map<String, Object>")
  @PostMapping("/list")
  public R list(@RequestParam Map<String, Object> params) {
    PageUtils page = sysDictionaryService.queryPage(params, null);
    return R.ok().put("page", page);
  }

  /**
   * 列表页面列表数据获取
   *
   * @param model 承接对象
   * @return
   */
  @ApiOperation(value = "根据条件获取数据字典表分页数据列表", notes = "根据条件获取数据字典表分页数据列表")
  @ApiImplicitParam(
      name = "params",
      value = "参数",
      required = true,
      dataType = "Map<String, Object>")
  @PostMapping("/dictionaryList")
  public R dictionaryList(@RequestBody SysDictionaryModel model) {
    List<SysDictionary> list = sysDictionaryService.queryPageList(model);
    return R.ok().put("page", getMyPage(list, model));
  }

  /** 查询父级下面的子级 */
  @RequestMapping("/getListByParent")
  public R getListByParent(String parentId, String stationId) {
    List<SysDictionary> beans = sysDictionaryService.queryByPid(parentId, stationId);
    return R.ok().put("list", beans);
  }

  /**
   * 添加
   *
   * @param bean 数据字典表对象
   * @return
   */
  @SysLogMethod(operation = "新增", blockName = "系统管理", detail = "新增数据字典数据")
  @ApiOperation(value = "新增数据字典表数据", notes = "新增数据字典表数据")
  @PostMapping("/save")
  public R save(@RequestBody @ApiParam(value = "数据字典表实体对象", required = true) SysDictionary bean) {
    ValidatorUtils.validateEntity(bean);
    // 校验参数
    List<SysDictionary> sysDictionaries =
        sysDictionaryService.queryByPid(bean.getParentId(), bean.getStationId());
    for (SysDictionary sysDictionary : sysDictionaries) {
      if (sysDictionary.getName().equals(bean.getName())) {
        return R.error("字典项名称已存在！");
      }
    }
//    String uuid = UUID.randomUUID().toString().replace("-", "");
//    bean.setId(uuid);
    bean.setCreateUserId(getUserId());
    bean.setCreateTime(new Date());
    bean.setSysSign(getUser().getSysSystem().getCode());
    sysDictionaryService.save(bean);
    return R.ok();
  }

  /**
   * 修改
   *
   * @param bean 数据字典表对象
   * @return
   */
  @SysLogMethod(operation = "修改", blockName = "系统管理", detail = "修改数据字典数据")
  @ApiOperation(value = "修改数据字典表数据", notes = "修改数据字典表数据")
  @PostMapping("/update")
  public R update(@RequestBody @ApiParam(value = "数据字典表实体对象", required = true) SysDictionary bean) {
    ValidatorUtils.validateEntity(bean);
    // 校验参数
    List<SysDictionary> sysDictionaries =
        sysDictionaryService.queryByPid(bean.getParentId(), bean.getStationId());
    for (SysDictionary sysDictionary : sysDictionaries) {
      if (!sysDictionary.getId().equals(bean.getId())
          && bean.getName().equals(sysDictionary.getName())) {
        return R.error("字典项名称已存在！");
      }
    }
    bean.setUpdateUserId(getUserId());
    bean.setUpdateTime(new Date());
    bean.setSysSign(getUser().getSysSystem().getCode());
    sysDictionaryService.update(
        bean,
        new QueryWrapper<SysDictionary>()
            .eq(StringUtil.checkNotNull(bean.getId()), "id", bean.getId())
            .eq(StringUtil.checkNotNull(bean.getStationId()), "station_id", bean.getStationId()));
    return R.ok();
  }

  /**
   * 根据ID获取数据字典表对象
   *
   * @param id 对象主键
   * @return
   */
  @ApiOperation(value = "根据ID获取数据字典表对象", notes = "根据ID获取数据字典表对象")
  @ApiImplicitParam(name = "id", value = "主键", required = true, dataType = "String")
  @GetMapping("/getId")
  public R getId(String id, String stationId) {
    SysDictionary bean = sysDictionaryService.queryById(id, stationId);
    return R.ok().put("bean", bean);
  }

  /**
   * 根据ID删除数据字典表对象
   *
   * @param
   * @return
   */
  @SysLogMethod(operation = "删除", blockName = "系统管理", detail = "删除数据字典数据")
  @ApiOperation(value = "根据ID批量删除数据字典表数据", notes = "根据ID批量删除数据字典表数据")
  @PostMapping("/deleteById")
  public R deleteById(
      @RequestBody @ApiParam(value = "数据字典表实体对象", required = true) SysDictionary bean) {
    ValidatorUtils.validateEntity(bean);
    bean.setUpdateUserId(getUserId());
    bean.setUpdateTime(new Date());
    bean.setDeleted(1);
    // 如果是二级，不可以删除，只能修改
    if (Constants.DIC_ROOT_ID.equals(bean.getParentId())) {
      return R.error(111, "该字典项不可以删除，只能修改!");
    }
    bean.setSysSign(getUser().getSysSystem().getCode());
    sysDictionaryService.update(
        bean,
        new QueryWrapper<SysDictionary>()
            .eq(StringUtil.checkNotNull(bean.getId()), "id", bean.getId())
            .eq(StringUtil.checkNotNull(bean.getStationId()), "station_id", bean.getStationId()));
    return R.ok();
  }

  /**
   * @param ids 数据字典表对象主键数组
   * @return 根据ID获取数据字典表对象
   */
  @ApiOperation(value = "根据ID批量删除数据字典表数据", notes = "根据ID批量删除数据字典数据")
  @ApiImplicitParam(name = "ids", value = "主键数组", required = true, dataType = "String")
  @PostMapping("/delete")
  public R delete(@RequestBody String[] ids) {
    sysDictionaryService.removeByIds(Arrays.asList(ids));
    return R.ok();
  }

  /**
   * 获取数据字典
   *
   * @param params 承接对象
   * @return
   */
  @ApiOperation(value = "获取所有数据字典", notes = "获取所有数据字典")
  @ApiImplicitParam(
      name = "params",
      value = "参数",
      required = true,
      dataType = "Map<String, Object>")
  @GetMapping("/dictionaryAllList")
  public R dictionaryAllList(@RequestParam Map<String, Object> params) {
    List<SysDictionary> lists = sysDictionaryService.getAllDictionary(params);
    String stationId = "";
    if (params.containsKey(Constants.STATION_ID)) {
      stationId = (String) params.get("stationId");
    }
    return R.ok().put("list", lists);
  }

  /**
   * 获取子系统字典项
   *
   * @return
   */
  @ApiOperation(value = "获取子系统字典项", notes = "获取子系统字典项")
  @GetMapping("/getSubSystemDicList")
  public R getSubSystemDicList(String stationId) {
    List<SysDictionary> list = sysDictionaryService.queryByPid(Constants.SUB_SYSTEM_ID, stationId);
    return R.ok().put("list", list);
  }

  /**
   * 获取资源点类型字典项
   *
   * @return
   */
  @ApiOperation(value = "获取资源点类型字典项", notes = "获取资源点类型字典项")
  @GetMapping("/getResourceTypeDicList")
  public R getResourceTypeDicList(String stationId) {
    List<SysDictionary> list = sysDictionaryService.queryByPid(Constants.RESOURCE_TYPE, stationId);
    return R.ok().put("list", list);
  }

  /**
   * 获取用户职业字典项
   *
   * @return
   */
  @ApiOperation(value = "获取用户职业字典项", notes = "获取用户职业字典项")
  @GetMapping("/getAllJobList")
  public R getAllJobList(String stationId) {
    List<SysDictionary> list = sysDictionaryService.queryByPid(Constants.USER_JOB, stationId);
    return R.ok().put("list", list);
  }

  /**
   * 品牌数据字典信息
   *
   * @return
   */
  @ApiOperation(value = "品牌数据字典信息", notes = "品牌数据字典信息")
  @GetMapping("/getBrandDicList")
  public R getBrandDicList(String stationId) {
    List<SysDictionary> list = sysDictionaryService.queryByPid(Constants.BRAND, stationId);
    return R.ok().put("list", list);
  }

  /**
   * 获取证件类型信息
   *
   * @return
   */
  @ApiOperation(value = "获取证件类型信息", notes = "获取证件类型信息")
  @GetMapping("/getCardTypeList")
  public R getCardTypeList(String stationId) {
    List<SysDictionary> list = sysDictionaryService.queryByPid(Constants.CARD_TYPE, stationId);
    return R.ok().put("list", list);
  }

  /** 测试使用 */
  @ApiImplicitParam(name = "id", value = "主键", required = true, dataType = "String")
  @GetMapping("/yujing")
  public R yujing() {
    Map<String, Object> map = new HashMap<>(8);
    map.put("id", "24dbfcbd7706493cbe09922d879f20c1");
    map.put("eventName", "红外对射报警");
    map.put("eventLevel", 2);
    map.put("occurrenceSite", "天府广场");
    map.put("occurrenceTime", "2020-08-20 21:44:52");
    map.put("resourceName", "红外对射");
    map.put("status", 1);
    map.put("fj", null);

    long beginTime = System.currentTimeMillis();
    webSocket.sendAllMessage(JSONObject.toJSONString(map));
    long end = System.currentTimeMillis();
    Long time = (end - beginTime);
    return R.ok().put("time", "系统对事件触发响应时间：" + time + "毫秒");
  }

  /** 测试使用 */
  @ApiImplicitParam(name = "id", value = "主键", required = true, dataType = "String")
  @GetMapping("/yujing1")
  public R yujing1() {
    Map<String, Object> map = new HashMap<>(8);
    map.put("id", "07b6a86cbf4f48049687168f5cca88ab");
    map.put("eventName", "一键报警按钮报警");
    map.put("eventLevel", 1);
    map.put("occurrenceSite", "天府广场");
    map.put("occurrenceTime", "2020-08-20 21:00:00");
    map.put("resourceName", "一键报警按钮");
    map.put("status", 1);
    map.put("fj", null);

    long beginTime = System.currentTimeMillis();
    webSocket.sendAllMessage(JSONObject.toJSONString(map));
    long end = System.currentTimeMillis();
    Long time = (end - beginTime);
    return R.ok().put("time", "系统对事件触发响应时间：" + time + "毫秒");
  }

  /** 测试使用 */
  @ApiImplicitParam(name = "id", value = "主键", required = true, dataType = "String")
  @GetMapping("/yujing2")
  public R yujing2() {
    Map<String, Object> map = new HashMap<>(8);
    map.put("id", "4b75d105ea094b81925ccb752e004e61");
    map.put("eventName", "红外对射报警");
    map.put("eventLevel", 3);
    map.put("occurrenceSite", "天府广场");
    map.put("occurrenceTime", "2020-08-20 21:20:52");
    map.put("resourceName", "红外对射");
    map.put("status", 1);
    map.put("fj", null);

    long beginTime = System.currentTimeMillis();
    webSocket.sendAllMessage(JSONObject.toJSONString(map));
    long end = System.currentTimeMillis();
    Long time = (end - beginTime);
    return R.ok().put("time", "系统对事件触发响应时间：" + time + "毫秒");
  }
}
