package com.devplatform.admin.modules.sysdictionary.dao;

import com.devplatform.admin.modules.sysdictionary.bean.SysDictionary;
import com.devplatform.admin.modules.sysdictionary.model.SysDictionaryModel;
import com.devplatform.common.dao.MyBaseMapper;
import java.util.List;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

/**
 * SysDictionary Mapper 用于数据字典表的数据库操作
 *
 * @author Administrator
 */
@Mapper
@Repository
public interface SysDictionaryDao extends MyBaseMapper<SysDictionary> {
  /**
   * 根据id查询字典
   * @param id
   * @param stationId
   * @return
   */
  SysDictionary queryById(@Param("id") String id, @Param("stationId") String stationId);

  /**
   * 查询分页数量
   * @param model
   * @return
   */
  Integer queryPageByCount(@Param("model") SysDictionaryModel model);

  /**
   * 根据父节点id查询字典项
   * @param parentId
   * @param stationId
   * @return
   */
  List<SysDictionary> queryByPid(
      @Param("parentId") String parentId, @Param("stationId") String stationId);

  /**
   * 查询字典项分页数据
   * @param model
   * @return
   */
  List<SysDictionary> queryPageList(@Param("model") SysDictionaryModel model);

  /**
   * 根据父节点id查询数量
   * @param parentId
   * @param stationId
   * @return
   */
  Integer queryCountByParentId(
      @Param("parentId") String parentId, @Param("stationId") String stationId);
}
