package ${bean.pacageName}${bean.modulesName}.controller;

import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;

import org.apache.commons.lang.ArrayUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;

import ${bean.pacageName}${bean.modulesName}.bean.${bean.className};
import ${bean.pacageName}${bean.modulesName}.model.${bean.className}Model;
import ${bean.pacageName}${bean.modulesName}.service.${bean.className}Service;
import ${bean.pacageName}sys.bean.SysUserEntity;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.devplatform.common.base.annotation.SysLog;
import com.devplatform.common.base.validator.ValidatorUtils;
import com.devplatform.common.util.HtmlUtil;
import com.devplatform.admin.common.utils.AbstractController;
import com.devplatform.common.util.PageUtils;
import com.devplatform.common.util.R;
import com.devplatform.common.util.StringUtil;

/**
 * <br>
 * <b>功能：</b>${bean.className}Controller<br>
 * @author 代码生成器产生
 */
@Api(tags={"${bean.tableRemark}接口"})
@RestController
@RequestMapping("/${bean.lowerName}")
public class ${bean.className}Controller extends AbstractController{
	
	@Autowired
	private ${bean.className}Service ${bean.lowerName}Service;

	/**
	 * 列表页面列表数据获取
	 * @param params 承接对象
	 * @return
	 */
	@ApiOperation(value="根据条件获取${bean.tableRemark}分页数据列表", notes="根据条件获取${bean.tableRemark}分页数据列表")
	@ApiImplicitParam(name = "params", value = "参数", required = true, dataType = "Map<String, Object>")
	@PostMapping("/list")
	public R list(@RequestParam Map<String, Object> params) {
		//分页查询
		PageUtils page = ${bean.lowerName}Service.queryPage(params,null);
		//返回分页结果
		return R.ok().put("page", page);
	}

	/**
	 * 列表页面列表数据获取
	 * @param model 承接对象
	 * @return
	 */
	@ApiOperation(value="根据条件获取${bean.tableRemark}分页数据列表", notes="根据条件获取${bean.tableRemark}分页数据列表")
	@ApiImplicitParam(name = "model", value = "参数", required = true, dataType = "${bean.className}Model")
	@PostMapping("/pageList")
	public R pageList(@RequestBody ${bean.className}Model model) {
		//如果model参数中没有设置排序方式，则默认以创建时间倒序排列
		if(StringUtil.isEmpty(model.getSort())){
			model.setSort("create_time desc");
		}
		//按条件查询分页数据
		List<${bean.className}> list = ${bean.lowerName}Service.queryPageList(model);
		//将查询结果中数据和数量封装起来做为接口返回值
		return R.ok().put("page", getMyPage(list,model));
	}
	
	/**
	 * 添加
	 * @param bean ${bean.tableRemark}对象
	 * @return
	 */
	@SysLog("添加${bean.tableRemark}")
	@ApiOperation(value="新增${bean.tableRemark}数据", notes="新增${bean.tableRemark}数据")
	@PostMapping("/save")
	public R save(@RequestBody @ApiParam(value="${bean.tableRemark}实体对象", required = true)${bean.className} bean) {
		ValidatorUtils.validateEntity(bean);
		bean.setCreateUserId(getUserId());
		bean.setCreateTime(new Date());
		${bean.lowerName}Service.save(bean);
		return R.ok();
	}
	
	/**
	 * 修改
	 * @param bean ${bean.tableRemark}对象
	 * @return
	 */
	@SysLog("修改${bean.tableRemark}")
	@ApiOperation(value="修改${bean.tableRemark}数据", notes="修改${bean.tableRemark}数据")
	@PostMapping("/update")
	public R update(@RequestBody @ApiParam(value="${bean.tableRemark}实体对象", required = true)${bean.className} bean) {
		ValidatorUtils.validateEntity(bean);
		bean.setUpdateUserId(getUserId());
		bean.setUpdateTime(new Date());
		${bean.lowerName}Service.update(bean,
				new QueryWrapper<${bean.className}>().eq(StringUtil.checkNotNull(bean.getId()),"id", bean.getId()));
		return R.ok();
	}
	
	/**
	 * 根据ID获取${bean.tableRemark}对象
	 * @param id 对象主键
	 * @return
	 */
	@ApiOperation(value="根据ID获取${bean.tableRemark}对象", notes="根据ID获取${bean.tableRemark}对象")
    @ApiImplicitParam(name = "id", value = "主键", required = true, dataType = "String")
	@GetMapping("/getId/{id}")
	public R getId(@PathVariable String id) {
		${bean.className} bean = ${bean.lowerName}Service.getById(id);
		return R.ok().put("bean", bean);
	}
	

	/**
	 * 根据ID获取${bean.tableRemark}对象
	 * @param ids ${bean.tableRemark}对象主键数组
	 * @return
	 */
	@SysLog("删除${bean.tableRemark}数据")
	@ApiOperation(value="根据ID批量删除${bean.tableRemark}数据", notes="根据ID批量删除${bean.tableRemark}数据")
    @ApiImplicitParam(name = "ids", value = "主键数组", required = true, dataType = "String")
	@PostMapping("/delete")
	public R delete(@RequestBody String[] ids) {
		${bean.lowerName}Service.removeByIds(Arrays.asList(ids));
		return R.ok();
	}

	/**
	 * 逻辑删除
	 * 根据ID删除${bean.tableRemark}对象
	 * @param ids ${bean.tableRemark}对象主键数组
	 * @return
	 */
	@SysLog("删除${bean.tableRemark}数据")
	@ApiOperation(value="根据ID批量删除${bean.tableRemark}数据", notes="根据ID批量删除${bean.tableRemark}数据")
	@ApiImplicitParam(name = "ids", value = "主键数组", required = true, dataType = "String[]")
	@PostMapping("/deleteByFlag")
	public R deleteByFlag(@RequestBody String[] ids) {
		//根据id数组删除
		${bean.lowerName}Service.deleteByFlagByIds(ids, getUserId());
		//返回成功
		return R.ok();
	}

}
