package com.devplatform.alarm;

import com.baomidou.mybatisplus.extension.plugins.PaginationInterceptor;
import lombok.extern.slf4j.Slf4j;
import org.apache.catalina.filters.CorsFilter;
import org.mybatis.spring.annotation.MapperScan;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.cloud.netflix.eureka.EnableEurekaClient;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.web.client.RestTemplate;
import springfox.documentation.swagger2.annotations.EnableSwagger2;

/**
 * springboot启动类
 *
 * @author Administrator
 */
@SpringBootApplication
@EnableSwagger2
@Slf4j
@MapperScan(basePackages = "com.devplatform.**.dao")
@EnableEurekaClient
@EnableFeignClients
@EnableScheduling
@ComponentScan(basePackages = {"com.devplatform"})
public class AlarmApplication {

  private static final Logger logger = LoggerFactory.getLogger(AlarmApplication.class);

  public static void main(String[] args) {
    SpringApplication.run(AlarmApplication.class, args);
  }

  @Bean
  public RestTemplate restTemplate() {
    // 复杂构造函数的使用
    SimpleClientHttpRequestFactory requestFactory = new SimpleClientHttpRequestFactory();
    // 设置超时
    requestFactory.setConnectTimeout(3000);
    requestFactory.setReadTimeout(3000);
    return new RestTemplate(requestFactory);
  }

  /**
   * 分页插件
   */
  @Bean
  public PaginationInterceptor paginationInterceptor() {
    return new PaginationInterceptor();
  }

//  /**
//   * bean注入corsFilter
//   */
//  @Bean
//  public FilterRegistrationBean corsFilterRegistration() {
//    FilterRegistrationBean registration = new FilterRegistrationBean();
//    registration.setFilter(new CorsFilter());
//    registration.addUrlPatterns("/*");
//    registration.setName("corsFilter");
//    //将其注册在其他过滤器的前面
//    registration.setOrder(0);
//    return registration;
//  }
}
