package com.devplatform.alarm.common.comsumer;

import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.devplatform.alarm.common.producer.PlanRabbitSender;
import com.devplatform.alarm.common.utils.Constants;
import com.devplatform.alarm.modules.emorg.bean.EmOrg;
import com.devplatform.alarm.modules.emproficient.bean.EmProficient;
import com.devplatform.alarm.modules.plan.bean.PlanRegister;
import com.devplatform.alarm.modules.plan.service.PlanRegisterService;
import com.devplatform.alarm.modules.synclog.bean.SyncLogData;
import com.devplatform.alarm.modules.synclog.service.SyncLogDataService;
import com.devplatform.alarm.modules.syssystem.bean.SysSystem;
import com.devplatform.alarm.modules.syssystem.service.SysSystemService;
import com.devplatform.routes.modules.plan.bean.RtPlanRegister;
import com.devplatform.routes.modules.plan.service.RtPlanRegisterService;
import com.rabbitmq.client.Channel;
import org.apache.commons.lang.StringUtils;
import org.springframework.amqp.rabbit.annotation.*;
import org.springframework.amqp.rabbit.annotation.Queue;
import org.springframework.amqp.support.AmqpHeaders;
import org.springframework.context.annotation.Bean;
import org.springframework.messaging.Message;
import org.springframework.messaging.handler.annotation.Headers;
import org.springframework.stereotype.Component;

import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import java.util.*;

/** 站点系统消费同步预案登记信息
 * @Author: jzj
 * @Date: 2020/9/25 15:39
 */
@Component
public class PlanRabbitConsumer {
    /**
     * 下发队列名称(预案下发)
     */
    public static final String DIC_QUEUE_PLAN_REGISTER = "queue-plan-";
    /**
     * 下发交换机(预案下发)
     */
    public static final String DIC_EXCHANGE_PLAN_REGISTER = "exchange-plan-register";

    @Resource
    private SysSystemService sysSystemService;
    @Resource
    private PlanRegisterService planRegisterService;
    @Resource
    private PlanRabbitSender rabbitSender;
    @Resource
    private SyncLogDataService syncLogDataService;
    @Resource
    private RtPlanRegisterService rtPlanRegisterService;

    private static SysSystem sysSystem;

    @PostConstruct
    @Bean
    public String getStationId(){
         sysSystem = sysSystemService.getOne(new QueryWrapper<SysSystem>());
        return sysSystem.getCode();
    }

    /**
     * direct根据设置的路由键，转发消息到所绑定的队列;
     * 预案下发消费者
     * @param message
     * @param channel
     * @throws Exception
     */
    @RabbitListener(bindings = @QueueBinding(
            value = @Queue(value = PlanRabbitConsumer.DIC_QUEUE_PLAN_REGISTER+"#{@getStationId}"),
            exchange = @Exchange(value = PlanRabbitConsumer.DIC_EXCHANGE_PLAN_REGISTER, type = "direct", ignoreDeclarationExceptions = "true")
            ,key = "#{@getStationId}")
    )
    @RabbitHandler
    public void onMessage(Message message, Channel channel,@Headers Map<String,Object> headers)throws Exception{
        Long deliveryTay = (Long) message.getHeaders().get(AmqpHeaders.DELIVERY_TAG);
        //1:添加 2:修改 3:删除
        String type = (String) headers.get("type");
        String lineId = (String) headers.get("lineId");
        String planId = (String) headers.get("planId");
        try{
            if(StringUtils.isNotBlank(type)  && StringUtils.isNotBlank(planId)){
                //对应站点消费，线路或者路网下发的数据
                if(Constants.STRING_1.equals(sysSystem.getType())){
                    //添加
                    if(Constants.STRING_1.equals(type)){
                        if(StringUtils.isNotBlank(lineId)){
                            //先删除后添加防止重复下发
                            removePlanInfo(planId,sysSystem.getCode());

                            RtPlanRegister bean = (RtPlanRegister) message.getPayload();
                            bean.setByx3(null);
                            exeMethod(bean);
                            //手工ACK
                            channel.basicAck(deliveryTay, false);
                            Map<String,Object> params = new HashMap<>(5);
                            params.put("type",type);
                            params.put("planId",planId);
                            params.put("stationId",sysSystem.getCode());
                            rabbitSender.send("消费成功，回执给线路或者路网系统",params,PlanRabbitConsumer.DIC_EXCHANGE_PLAN_REGISTER,lineId);
                        }else{
                            channel.basicNack(deliveryTay, false, false);
                        }
                    }

                    //撤回删除
                    if(Constants.STRING_3.equals(type)){
                            rollBackPlanInfo(planId);
                            //手工ACK
                            channel.basicAck(deliveryTay, false);
                    }
                } else {//线路或站点，将站点回执的消息入库  ，确保站点数据下发成功
                    String stationId = (String) headers.get("stationId");
                    SyncLogData syncLogData = syncLogDataService.getOne(new LambdaQueryWrapper<SyncLogData>().eq(SyncLogData::getPlanId,planId)
                            .eq(SyncLogData::getStationId,stationId).eq(SyncLogData::getType,Constants.INT_1));
                    if(syncLogData == null){
                        syncLogData = new SyncLogData();
                        syncLogData.setPlanId(planId);
                        syncLogData.setStationId(stationId);
                        syncLogData.setCreateTime(new Date());
                        syncLogData.setType(1);
                    }
                    syncLogData.setStatus(1);
                    if(StringUtils.isNotBlank(syncLogData.getId())){
                        syncLogDataService.update(syncLogData,new LambdaQueryWrapper<SyncLogData>().eq(SyncLogData::getId,syncLogData.getId()));
                    }else {
                        syncLogDataService.save(syncLogData);
                    }

                    RtPlanRegister rtPlanRegister = rtPlanRegisterService.queryById(planId);
                    //适用范围的站点数量
                    int num = rtPlanRegister.getByx3().split(",").length;
                    int sucNum = syncLogDataService.count(new LambdaQueryWrapper<SyncLogData>().eq(SyncLogData::getPlanId,planId)
                            .eq(SyncLogData::getType,1).eq(SyncLogData::getStatus,1));
                    //如果都同步成功了，则预案发布成功，否则发布失败
                    if(num == sucNum){
                        rtPlanRegister.setStatus(3);
                    }else{
                        rtPlanRegister.setStatus(2);
                    }
                    rtPlanRegisterService.update(rtPlanRegister,new LambdaQueryWrapper<RtPlanRegister>().eq(RtPlanRegister::getId,rtPlanRegister.getId()));

                    //手工ACK
                    channel.basicAck(deliveryTay, false);
                }
            } else {
                channel.basicNack(deliveryTay, false, false);
            }
        }catch (Exception e) {
            e.printStackTrace();
            // 丢弃该消息
            channel.basicNack(deliveryTay, false, false);

        }
    }



    /**
     * 将线路或者路网下发的预案登记信息添加到对应的站点系统
     * @param rtPlanRegister
     * @throws Exception
     */
    public void exeMethod(RtPlanRegister rtPlanRegister) throws Exception {
        //预案基本信息
        Object obj = JSONArray.toJSON(rtPlanRegister);
        String str = obj.toString();
        PlanRegister bean = JSONArray.parseObject(str, PlanRegister.class);
        String planId = UUID.randomUUID().toString().replace("-", "");
        String stationId = bean.getStationId();
        String byx2 = bean.getId();

        bean.setByx1("1");
        bean.setStatus(2);
        bean.setByx2(bean.getId());
        bean.setSysSign(stationId);
        bean.setId(planId);
        //预案流程
        if(bean.getStepList() != null && bean.getStepList().size() > 0){
            for (int i=0; i<bean.getStepList().size(); i++) {
                bean.getStepList().get(i).setStationId(stationId);
                bean.getStepList().get(i).setSysSign(stationId);
                bean.getStepList().get(i).setPlanId(planId);
                bean.getStepList().get(i).setByx1("1");
                bean.getStepList().get(i).setByx2(byx2);
                bean.getStepList().get(i).setId(null);
            }
        }
        //应急团队
        if(bean.getProficientList() != null && bean.getProficientList().size() > 0){
            for (int i=0; i<bean.getProficientList().size(); i++) {
                bean.getProficientList().get(i).setStationId(stationId);
                bean.getProficientList().get(i).setSysSign(stationId);
                bean.getProficientList().get(i).setPlanId(planId);
                bean.getProficientList().get(i).setByx1("1");
                bean.getProficientList().get(i).setByx2(byx2);
                bean.getProficientList().get(i).setId(null);
            }
        }
        //应急部门
        if(bean.getOrgList() != null && bean.getOrgList().size() > 0){
            for (int i=0; i<bean.getOrgList().size(); i++) {
                bean.getOrgList().get(i).setStationId(stationId);
                bean.getOrgList().get(i).setSysSign(stationId);
                bean.getOrgList().get(i).setPlanId(planId);
                bean.getOrgList().get(i).setByx1("1");
                bean.getOrgList().get(i).setByx2(byx2);
                bean.getOrgList().get(i).setId(null);
            }
        }
        //应急团队(应急数据管理)
        if(bean.getProId() != null && bean.getProId().size() > 0){
            for (EmProficient emProficient: bean.getEmProficientList()) {
                emProficient.setStationId(stationId);
                emProficient.setSysSign(stationId);
                emProficient.setByx1("1");
                emProficient.setByx2(emProficient.getId());
                emProficient.setId(null);
            }
        }
        if(bean.getOrgId() != null && bean.getOrgId().size() > 0){
            for (EmOrg emOrg : bean.getEmOrgList()) {
                emOrg.setStationId(stationId);
                emOrg.setSysSign(stationId);
                emOrg.setByx1("1");
                emOrg.setByx2(emOrg.getId());
                emOrg.setId(null);
            }
        }

        planRegisterService.issueSaveAllMq(bean);
    }

    /**
     * 删除站点系统中，线路或者路网撤回的预案登记信息
     * @param planId 预案id
     * @throws Exception
     */
    public void rollBackPlanInfo(String planId)throws Exception {
        planRegisterService.removePlanInfo(planId);

    }

    public void removePlanInfo(String planId,String stationId)throws Exception {
        planRegisterService.removePlanInfoById(planId,stationId);

    }
}
