package com.devplatform.alarm.common.utils;

import com.devplatform.alarm.common.model.BaseModel;
import com.devplatform.alarm.feign.bean.JsonBean;
import com.devplatform.alarm.feign.bean.SysUserEntity;
import com.devplatform.alarm.feign.service.AdminService;
import com.devplatform.alarm.modules.sys.service.SysLogService;
import com.devplatform.common.controller.BaseController;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * Controller公共组件
 *
 * @author geqilin
 * @email geqilin@suntray.com
 * @date 2020年6月25日 下午9:42:26
 */
public abstract class AbstractController extends BaseController {
  protected Logger logger = LoggerFactory.getLogger(getClass());

  @Autowired(required = false)
  private AdminService getUserInfoService;

  @Autowired(required = false)
  private SysLogService sysLogService;

  /**
   * 获取当前登录人ID
   *
   * @return
   */
  public SysUserEntity getUser() {
    return getCurrentUserInfoMap().getGetUser();
  }

  /**
   * 获取当前登录人ID
   *
   * @return
   */
  public String getUserId() {
    return getCurrentUserInfoMap().getUserId();
  }

  /**
   * 获取当前登录人姓名
   *
   * @return
   */
  public String getCurrentUserName() {

    return getCurrentUserInfoMap().getCurrentUserName();
  }

  /**
   * 获取当前登录人真实姓名
   *
   * @return
   */
  public String getCurrentUserRealName() {
    return getCurrentUserInfoMap().getName();
  }

  public JsonBean getCurrentUserInfoMap() {
    String result = getUserInfoService.getCurrentUserInfo();
    // 解析获取accessToken
    JsonBean jsonBean = null;
    Gson g = new GsonBuilder().setDateFormat("yyyy-MM-dd HH:mm:ss").create();
    try {
      jsonBean = g.fromJson(result, JsonBean.class);
    } catch (Exception e) {
      e.printStackTrace();
    }
    return jsonBean;
  }

  /**
   * 分页类
   *
   * @param list
   * @param model
   * @return
   * @throws Exception MyPage
   * @throws @author Rice
   * @date 2017年9月22日
   */
  public <T> MyPage getMyPage(List<T> list, BaseModel model) {
    MyPage page = new MyPage();
    page.setRows(list);
    page.setTotal(model.getPager().getRowCount());
    return page;
  }

  public void saveLogRoutes(
      String operation,
      String blockName,
      String detail,
      String method,
      Object param,
      SysUserEntity user,
      Long startTime,
      String sysSign,
      String stationId) {
    sysLogService.saveLogRoutesSub(
        operation, blockName, detail, method, param, user, startTime, sysSign, stationId);
  }
}
