package com.devplatform.alarm.common.utils;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.http.Consts;
import org.apache.http.HttpEntity;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
/**
 * @author Administrator
 */
public class TestClient {

  public static Map<String, Object> uploadText(String postUrl, Map<String, String> postParam) {
    Logger log = LoggerFactory.getLogger(TestClient.class);

    Map<String, Object> resultMap = new HashMap<String, Object>(5);
    CloseableHttpClient httpClient = HttpClients.createDefault();
    try {
      // 把一个普通参数和文件上传给下面这个地址 是一个servlet
      HttpPost httpPost = new HttpPost(postUrl);
      // 设置传输参数
      MultipartEntityBuilder multipartEntity = MultipartEntityBuilder.create();
      // 设置参数
      Set<String> keySet = postParam.keySet();
      for (String key : keySet) {
        // 相当于<input type="text" name="name" value=name>
        multipartEntity.addPart(
            key,
            new StringBody(postParam.get(key), ContentType.create("text/plain", Consts.UTF_8)));
      }
      HttpEntity reqEntity = multipartEntity.build();
      httpPost.setEntity(reqEntity);

      log.info("发起请求的页面地址 " + httpPost.getRequestLine());
      // 发起请求 并返回请求的响应
      CloseableHttpResponse response = httpClient.execute(httpPost);
      try {
        log.info("----------------------------------------");
        // 打印响应状态
        resultMap.put("statusCode", response.getStatusLine().getStatusCode());
        // 获取响应对象
        HttpEntity resEntity = response.getEntity();
        if (resEntity != null) {
          // 打印响应长度
          log.info("Response content length: " + resEntity.getContentLength());
          // 打印响应内容
          resultMap.put("data", EntityUtils.toString(resEntity, Charset.forName("UTF-8")));
        }
        // 销毁
        EntityUtils.consume(resEntity);
      } catch (Exception e) {
        e.printStackTrace();
      } finally {
        response.close();
      }
    } catch (ClientProtocolException e1) {
      e1.printStackTrace();
    } catch (IOException e1) {
      e1.printStackTrace();
    } finally {
      try {
        httpClient.close();
      } catch (IOException e) {
        e.printStackTrace();
      }
    }
    log.info("uploadFile result:" + resultMap);
    return resultMap;
  }

  /**
   * 检测网络资源是否存在
   *
   * @return
   */
  //	public static boolean isNetFileAvailable(String strUrl) {
  //		InputStream netFileInputStream = null;
  //		try {
  //			URL url = new URL(strUrl);
  //			URLConnection urlConn = url.openConnection();
  //			netFileInputStream = urlConn.getInputStream();
  //			if (null != netFileInputStream) {
  //				return true;
  //			} else {
  //				return false;
  //			}
  //		} catch (IOException e) {
  //			return false;
  //		} finally {
  //			try {
  //				if (netFileInputStream != null)
  //					netFileInputStream.close();
  //			} catch (IOException e) {
  //				e.printStackTrace();
  //			}
  //		}
  //	}

  public static byte[] readInputStream(InputStream inStream) throws Exception {
    ByteArrayOutputStream outStream = new ByteArrayOutputStream();
    // 创建一个Buffer字符串
    byte[] buffer = new byte[1024];
    // 每次读取的字符串长度，如果为-1，代表全部读取完毕
    int len = 0;
    // 使用一个输入流从buffer里把数据读取出来
    while ((len = inStream.read(buffer)) != -1) {
      // 用输出流往buffer里写入数据，中间参数代表从哪个位置开始读，len代表读取的长度
      outStream.write(buffer, 0, len);
    }
    // 关闭输入流
    inStream.close();
    // 把outStream里的数据写入内存
    return outStream.toByteArray();
  }

  public static void main(String[] args) throws Exception {
    // 要上传的文件的路径
    String postUrl = "http://localhost:8089/command/operation";
    // 要上传的数据组装
    Map<String, String> postParam = new HashMap<String, String>(10);
    postParam.put("liResourceId", "f6gf9j86fjdj81s18sdh131e64rti64u1k");
    postParam.put("stationId", "40bf04d6f2e2ec3bfbb43aa51a7fac42");
    postParam.put("params", "1");
    postParam.put("userId", "2d63e635046e4808a38c308c94c9453b");
    postParam.put("levelType", "1");
    postParam.put("controlType", "1");
    // 调用post工具
    Map<String, Object> resultMap = uploadText(postUrl, postParam);
    System.out.println(resultMap);
  }
}
