package com.devplatform.alarm.common.utils;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

/** @Author Muceball @Date 2020-7-11 11:04:41 @Version 1.0 */
public class ThreadPool {
  /** 线程池核心池的大小*/
  private static final int CORE_POOL_SIZE = 10;
  /** 最大阻塞队列（超出队列的将会被丢弃，不会执行。无界队列容易出现oom）*/
  private static final int BLOCKING_QUEUE = 1024;
  /** 线程池对象*/
  public static ExecutorService threadPoolExecutor = null;
  /** 获取当前系统java虚拟机的可用的处理器数量*/
  static int cpuNums = Runtime.getRuntime().availableProcessors();
  /** 线程池的最大线程数*/
  private static final int MAXIMUM_POOL_SIZE = Math.max(20, cpuNums * 5);

  /** 静态方法 */
  static {
    ThreadFactory threadFactory = new ThreadFactoryBuilder().setNameFormat("thread-%d").build();
    RejectedExecutionHandler handler = new MyIgnorePolicy();
    threadPoolExecutor =
        new ThreadPoolExecutor(
            CORE_POOL_SIZE,
            MAXIMUM_POOL_SIZE,
            0L,
            TimeUnit.MILLISECONDS,
            new LinkedBlockingQueue<>(BLOCKING_QUEUE),
            threadFactory,
            handler);
    System.err.println("创建线程数:" + CORE_POOL_SIZE + ",最大线程数:" + MAXIMUM_POOL_SIZE);
  }

  public static class MyIgnorePolicy implements RejectedExecutionHandler {

    @Override
    public void rejectedExecution(Runnable r, ThreadPoolExecutor e) {
      doLog(r, e);
    }

    private void doLog(Runnable r, ThreadPoolExecutor e) {
      // 可做日志记录等
      System.err.println(r.toString() + " 被驳回，没有执行！");
    }
  }
}
