package com.devplatform.alarm.config;

import com.devplatform.common.base.exception.RRException;
import com.devplatform.common.util.R;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;

/**
 * @author Muceball
 * @date 2020/6/5 20:53
 */
@ControllerAdvice
public class GlobalExceptionHandler {

  @ExceptionHandler(value = Exception.class)
  @ResponseBody
  public R exceptionHandler(Exception e) {
    e.printStackTrace();
    return R.error();
  }

  @ExceptionHandler(value = RRException.class)
  @ResponseBody
  public R exceptionRrHandler(Exception e) {
    e.printStackTrace();
    return R.error(e.getMessage());
  }
}
