package com.devplatform.alarm.feign.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import org.springframework.format.annotation.DateTimeFormat;

/**
 * 系统用户
 *
 * @author chenshun
 * @email sunlightcs@gmail.com
 * @date 2016年9月18日 上午9:28:55
 */
@ApiModel(value = "用户对象", description = "用户对象user")
@TableName("sys_user")
public class SysUserEntity implements Serializable {

  private static final long serialVersionUID = 1L;

  @ApiModelProperty("主键user_id")
  @TableId
  private String userId;

  @ApiModelProperty("部门id")
  private String orgId;

  @ApiModelProperty("用户姓名")
  private String name;

  @ApiModelProperty("账号")
  private String username;

  @ApiModelProperty("密码")
  private String password;

  @ApiModelProperty("用户岗位")
  private String job;

  @ApiModelProperty("工种")
  private String work;

  @ApiModelProperty("手机号")
  private String mobile;

  @ApiModelProperty("身份证号码")
  private String idCard;

  @ApiModelProperty("邮箱")
  private String email;

  @ApiModelProperty("学历")
  private String education;

  @ApiModelProperty("名族")
  private String nation;

  @ApiModelProperty("入职时间")
  @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
  @DateTimeFormat(pattern = "yyyy-MM-dd")
  private Date entryTime;

  @ApiModelProperty("工号")
  private String jobNumber;

  @ApiModelProperty("政治面貌")
  private String politicCountenance;

  @ApiModelProperty("性别 0：女 1：男")
  private Integer gender;

  @ApiModelProperty("状态0：禁用1：正常")
  private Integer status;

  @ApiModelProperty("盐")
  private String salt;

  @ApiModelProperty("(未启用)")
  private String detail;

  @ApiModelProperty("是否已删除(0未删除，1已删除)")
  private Integer deleted;

  @ApiModelProperty("系统标识")
  private String sysSign;

  @ApiModelProperty("创建人")
  private String createUserId;

  @ApiModelProperty("创建时间")
  private Date createTime;

  @ApiModelProperty("修改人")
  private String updateUserId;

  @ApiModelProperty("修改时间")
  private Date updateTime;

  @ApiModelProperty("备用项1")
  private String byx1;

  @ApiModelProperty("备用项2")
  private String byx2;

  @ApiModelProperty("备用项3")
  private String byx3;

  @TableField(exist = false)
  private List<String> roleIdList;

  @ApiModelProperty("角色列表")
  @TableField(exist = false)
  private List<SysRoleEntity> userRoleList;

  @ApiModelProperty("系统信息")
  @TableField(exist = false)
  private SysSystem sysSystem;

  public SysSystem getSysSystem() {
    return sysSystem;
  }

  public void setSysSystem(SysSystem sysSystem) {
    this.sysSystem = sysSystem;
  }

  public String getUserId() {
    return userId;
  }

  public void setUserId(String userId) {
    this.userId = userId;
  }

  public String getOrgId() {
    return orgId;
  }

  public void setOrgId(String orgId) {
    this.orgId = orgId;
  }

  public String getUsername() {
    return username;
  }

  public void setUsername(String username) {
    this.username = username;
  }

  public String getPassword() {
    return password;
  }

  public void setPassword(String password) {
    this.password = password;
  }

  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public String getJob() {
    return job;
  }

  public void setJob(String job) {
    this.job = job;
  }

  public Integer getGender() {
    return gender;
  }

  public void setGender(Integer gender) {
    this.gender = gender;
  }

  public String getSalt() {
    return salt;
  }

  public void setSalt(String salt) {
    this.salt = salt;
  }

  public String getEmail() {
    return email;
  }

  public void setEmail(String email) {
    this.email = email;
  }

  public String getMobile() {
    return mobile;
  }

  public void setMobile(String mobile) {
    this.mobile = mobile;
  }

  public String getDetail() {
    return detail;
  }

  public void setDetail(String detail) {
    this.detail = detail;
  }

  public Integer getStatus() {
    return status;
  }

  public void setStatus(Integer status) {
    this.status = status;
  }

  public String getCreateUserId() {
    return createUserId;
  }

  public void setCreateUserId(String createUserId) {
    this.createUserId = createUserId;
  }

  public Date getCreateTime() {
    return createTime;
  }

  public void setCreateTime(Date createTime) {
    this.createTime = createTime;
  }

  public String getUpdateUserId() {
    return updateUserId;
  }

  public void setUpdateUserId(String updateUserId) {
    this.updateUserId = updateUserId;
  }

  public Date getUpdateTime() {
    return updateTime;
  }

  public void setUpdateTime(Date updateTime) {
    this.updateTime = updateTime;
  }

  public String getByx1() {
    return byx1;
  }

  public void setByx1(String byx1) {
    this.byx1 = byx1;
  }

  public String getByx2() {
    return byx2;
  }

  public void setByx2(String byx2) {
    this.byx2 = byx2;
  }

  public String getByx3() {
    return byx3;
  }

  public void setByx3(String byx3) {
    this.byx3 = byx3;
  }

  public List<String> getRoleIdList() {
    return roleIdList;
  }

  public void setRoleIdList(List<String> roleIdList) {
    this.roleIdList = roleIdList;
  }

  public List<SysRoleEntity> getUserRoleList() {
    return userRoleList;
  }

  public void setUserRoleList(List<SysRoleEntity> userRoleList) {
    this.userRoleList = userRoleList;
  }

  public String getWork() {
    return work;
  }

  public void setWork(String work) {
    this.work = work;
  }

  public String getIdCard() {
    return idCard;
  }

  public void setIdCard(String idCard) {
    this.idCard = idCard;
  }

  public String getEducation() {
    return education;
  }

  public void setEducation(String education) {
    this.education = education;
  }

  public String getNation() {
    return nation;
  }

  public void setNation(String nation) {
    this.nation = nation;
  }

  public Date getEntryTime() {
    return entryTime;
  }

  public void setEntryTime(Date entryTime) {
    this.entryTime = entryTime;
  }

  public String getJobNumber() {
    return jobNumber;
  }

  public void setJobNumber(String jobNumber) {
    this.jobNumber = jobNumber;
  }

  public String getPoliticCountenance() {
    return politicCountenance;
  }

  public void setPoliticCountenance(String politicCountenance) {
    this.politicCountenance = politicCountenance;
  }

  public Integer getDeleted() {
    return deleted;
  }

  public void setDeleted(Integer deleted) {
    this.deleted = deleted;
  }

  public String getSysSign() {
    return sysSign;
  }

  public void setSysSign(String sysSign) {
    this.sysSign = sysSign;
  }
}
