package com.devplatform.alarm.feign.config;

import com.devplatform.common.util.ValidateUtil;
import feign.RequestInterceptor;
import feign.RequestTemplate;
import javax.servlet.http.HttpServletRequest;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

/**
 * @author Administrator
 */
public class FeignConfig implements RequestInterceptor {

  @Override
  public void apply(RequestTemplate template) {
    HttpServletRequest request = getHttpServletRequest();
    if (request != null) {
      String tmpToken = request.getHeader("token");
      if (null != request && !ValidateUtil.isEmpty(tmpToken)) {
        template.header("token", tmpToken);
      }
    }
  }

  private HttpServletRequest getHttpServletRequest() {
    try {
      return ((ServletRequestAttributes) RequestContextHolder.getRequestAttributes()).getRequest();
    } catch (Exception e) {
      return null;
    }
  }
}
