package com.oauth.security;

import lombok.extern.slf4j.Slf4j;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.web.bind.annotation.RestController;

/**
 * Created on 2018/4/28.
 *
 * @author szy
 * @since 1.0
 */
@RestController
@SpringBootApplication(exclude = {DataSourceAutoConfiguration.class})
@Slf4j
@EnableFeignClients
public class SpringBoot2Oauth2Application {

  public static void main(String[] args) {
    SpringApplication.run(SpringBoot2Oauth2Application.class, args);
  }
}
