package com.oauth.security.security.jwt;

import org.apache.shiro.crypto.hash.Sha256Hash;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.stereotype.Component;

/**
 * Created on 2018/7/17. 配置密码加密方式，用来JWT验证用户密码
 *
 * @author szy
 * @since 1.0
 */
@Component
public class CustomPasswordEncoder implements PasswordEncoder {

  @Override
  public String encode(CharSequence rawPassword) {
    return hashPwd(rawPassword.toString(), "");
  }

  @Override
  public boolean matches(CharSequence rawPassword, String encodedPassword) {
    // 不校验密码
    return true;

    //        try {
    //            String md5Pwd = "";
    //            String passWord = "";
    //            // 如果是验证用户信息，那么请统一加密方式
    //            if(encodedPassword!=null&&encodedPassword.length()>64){
    //                JSONObject userAccountObj = JSONObject.parseObject(encodedPassword);
    //                String salt = "";
    //                if(userAccountObj!=null) {
    //                    try {
    //                        passWord=userAccountObj.get("password").toString();
    //                        salt=userAccountObj.get("salt").toString();
    //                        md5Pwd = hashPwd(rawPassword.toString(), salt);
    //                    } catch (Exception e) {
    //                        e.printStackTrace();
    //                    }
    //                }
    //            } else {
    //                passWord = encodedPassword;
    //                md5Pwd = hashPwd(rawPassword.toString(), "");
    //            }
    //
    //            if(passWord.equals(md5Pwd)) {
    //                return true;
    //            }
    //            return false;
    //        }catch(Exception e){
    //            return false;
    //        }
  }

  private String hashPwd(String pwd, String salt) {
    return new Sha256Hash(pwd, salt).toHex();
  }
}
