package com.devplatform.equipment;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.devplatform.equipment.common.utils.Constants;
import com.devplatform.equipment.common.utils.SpringContextUtil;
import com.devplatform.equipment.common.utils.TestClient;
import com.devplatform.equipment.modules.ewarning.service.EwarningService;
import com.devplatform.equipment.modules.listation.bean.LiStation;
import com.devplatform.equipment.modules.listation.service.LiStationService;
import com.devplatform.equipment.modules.sys.bean.SysSystem;
import com.devplatform.equipment.modules.sys.service.SysSystemService;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.mybatis.spring.annotation.MapperScan;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.cloud.netflix.eureka.EnableEurekaClient;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.context.annotation.Import;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.transaction.annotation.EnableTransactionManagement;
import springfox.documentation.swagger2.annotations.EnableSwagger2;

/**
 * springboot启动类
 *
 * @author Administrator
 */
@SpringBootApplication
@EnableSwagger2
@MapperScan(basePackages = "com.devplatform.**.dao")
@EnableEurekaClient
@EnableFeignClients
@EnableScheduling
@EnableTransactionManagement
@Import(SpringContextUtil.class)
public class EquipmentApplication {

    public static void main(String[] args) {
        SpringApplication.run(EquipmentApplication.class, args);
//        handleMqInit();
//        sendMsg();
    }

    private static void handleMqInit() {
        LiStationService liStationService =
                (LiStationService) SpringContextUtil.getBean(LiStationService.class);
        SysSystemService sysSystemService =
                (SysSystemService) SpringContextUtil.getBean(SysSystemService.class);
        EwarningService ewarningService =
                (EwarningService) SpringContextUtil.getBean(EwarningService.class);

        SysSystem sysSystem = sysSystemService.getOne(new LambdaQueryWrapper<>());
        // 站点
        List<LiStation> lists = null;
        if (Constants.STRING_1.equals(sysSystem.getType())) {
            lists =
                    liStationService.list(
                            new LambdaQueryWrapper<LiStation>()
                                    .eq(LiStation::getDeleted, 0)
                                    .eq(LiStation::getId, sysSystem.getCode())
                                    .orderByAsc(LiStation::getOrderNum));
        } else if (Constants.STRING_2.equals(sysSystem.getType())) {
            //线路
            lists =
                    liStationService.list(
                            new LambdaQueryWrapper<LiStation>()
                                    .eq(LiStation::getDeleted, 0)
                                    .eq(LiStation::getLineId, sysSystem.getCode())
                                    .orderByAsc(LiStation::getOrderNum));
        } else {
            //路网
            lists =
                    liStationService.list(
                            new LambdaQueryWrapper<LiStation>()
                                    .eq(LiStation::getDeleted, 0)
                                    .orderByAsc(LiStation::getLineId, LiStation::getOrderNum));
        }
        if (lists != null && lists.size() > 0) {
            for (int i = 0; i < lists.size(); i++) {
                System.out.println("初始化MQ消费端");
                ewarningService.initMq(lists.get(i).getId());
            }
        }
    }

    private static void sendMsg() {
        EwarningService ewarningService = (EwarningService) SpringContextUtil.getBean(EwarningService.class);
        SysSystemService sysSystemService = (SysSystemService) SpringContextUtil.getBean(SysSystemService.class);
        SysSystem sysSystem = sysSystemService.getById(Constants.STRING_1);
        //如果是站点，判断是否需要发送断开连接的信息
        if (Constants.STRING_1.equals(sysSystem.getType())) {
            Map<String, Object> map = ewarningService.getOneArUpConfig(sysSystem.getCode());
            if (map != null && !map.isEmpty()) {
                Map<String, String> postParam = new HashMap<>(10);
                String stationId = (String) map.get("station_id");
                String path = (String) map.get("path");

                postParam.put("id", stationId);
                postParam.put("addressCode", sysSystem.getByx2());
                //状态，0=断开连接，1=故障恢复
                postParam.put("state", "1");
                TestClient.uploadText(path + Constants.HTTP_NOTICE, postParam);
            }
        }
    }
}
