package com.devplatform.equipment.common.utils;


import com.devplatform.equipment.modules.sys.bean.SysFileDatasource;
import com.devplatform.equipment.modules.sys.bean.SysSystem;
import com.devplatform.equipment.modules.sys.model.SysFileDatasourceModel;
import com.devplatform.equipment.modules.sys.service.SysFileDatasourceService;
import com.devplatform.equipment.modules.sys.service.SysSystemService;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.List;

/**
 * @author Administrator
 */
public class FtpUploadThread extends Thread {


    private String basePath;
    private String filePath;
    private String fileName;
    public FtpUploadThread(String basePath, String filePath, String fileName) {
        this.basePath = basePath;
        this.filePath = filePath;
        this.fileName = fileName;
    }

    @Override
    public void run() {
        try {
            System.out.println("执行附件传输推流任务，到线路和路网，basePath："+basePath + "---filePath:"+filePath + "---fileName:" + fileName);
            SysFileDatasourceService sysFileDatasourceService = (SysFileDatasourceService) SpringContextUtil.getBean(SysFileDatasourceService.class);
            SysSystemService sysSystemService = (SysSystemService) SpringContextUtil.getBean(SysSystemService.class);
            SysSystem byId = sysSystemService.getById(Constants.STRING_1);
            //站点系统同步到线路系统
            SysFileDatasourceModel model = new SysFileDatasourceModel();
            List<SysFileDatasource> list = sysFileDatasourceService.queryList(model);
            for (int i = 0; i < list.size(); i++) {
                SysFileDatasource datasource = list.get(i);
                // type类型 1:站点 2:线路 3:线网
                if(!datasource.getType().toString().equals(byId.getType())){
                    File fileNew = new File(basePath + filePath + fileName);
                    InputStream inputStream = new FileInputStream(fileNew);
                    SftpUtil.uploadFile(datasource.getUsername(), datasource.getPassword(), datasource.getIp(), 22, basePath,
                            "/" + filePath, fileName, null, inputStream);
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
