package com.devplatform.equipment.common.utils;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.devplatform.common.util.R;
import com.devplatform.equipment.modules.eppatrolplan.bean.TimedTask;
import com.devplatform.equipment.modules.eppatrolplan.controller.EpPatrolPlanController;
import com.devplatform.equipment.modules.eppatrolplan.service.TimedTaskService;

import java.text.SimpleDateFormat;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

/**
 * @author Administrator
 */
@Component
@Order(2)
public class InitRunner implements CommandLineRunner {
    @Autowired
    private TimedTaskService timedTaskService;

    @Autowired
    private EpPatrolPlanController epPatrolPlanController;

    @Override
    public void run(String... args) throws Exception {
        try {
            // 获取定时任务信息
            List<TimedTask> list = timedTaskService.list(new LambdaQueryWrapper<TimedTask>().eq(TimedTask::getDeleted, 0));
            if (list.isEmpty()) {
                return;
            }
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            for (TimedTask timedTask : list) {
                R r = epPatrolPlanController.sendMail(timedTask.getPlanId(), timedTask.getStationId(), sdf.format(timedTask.getSendTime()), "1");
                if (!"0".equals(r.get("code").toString())) {
                    System.err.println("定时任务启动失败！！");
                }
            }
        } catch (Exception e) {
            System.err.println("定时任务启动失败！");
            e.printStackTrace();
        }
    }
}
