package com.devplatform.equipment.common.utils;

import com.devplatform.equipment.modules.ewarning.service.EwarningService;
import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.ConnectionFactory;
import com.rabbitmq.client.Consumer;
import com.rabbitmq.client.DefaultConsumer;
import com.rabbitmq.client.Envelope;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

import java.io.IOException;

/**
 * 接收消息
 *
 * @author 李杨
 */
public class RabbitMqProvider {
  public void resMsg(String host,String username,String password,int port,String virtualHost,String stationId) {
    System.out.println("host:" + host);
    try {
      ConnectionFactory factory = new ConnectionFactory();
      factory.setUsername(username);
      factory.setPassword(password);
      factory.setHost(host);
      factory.setVirtualHost(virtualHost);
      factory.setPort(port);
      Connection connection = factory.newConnection();
      Channel channel = connection.createChannel();
      channel.queueDeclare(Constants.QUEUE_NAME + stationId, false, false, false, null);
      Consumer consumer =
          new DefaultConsumer(channel) {
            @Override
            public void handleDelivery(
                String consumerTag, Envelope envelope, AMQP.BasicProperties properties, byte[] body)
                throws IOException {
              EwarningService eWarningService =
                  (EwarningService) SpringContextUtil.getBean(EwarningService.class);
              Boolean flag = eWarningService.isResMsg(stationId);
              if (flag) {
                String message = new String(body, "UTF-8");
                System.out.println(" [x] Received '" + message + "'");
                eWarningService.handleAlarmsInfo(message);
                // 手动进行ACK
                channel.basicAck(envelope.getDeliveryTag(), false);
              } else {
                // 拒绝接受消息
                channel.basicReject(envelope.getDeliveryTag(), true);
              }
            }
          };
      // 监听队列，第二个参数：是否自动进行消息确认
      channel.basicConsume(Constants.QUEUE_NAME + stationId, false, consumer);
    } catch (Exception e) {
      e.printStackTrace();
    }
  }
}
