package com.devplatform.equipment.common.utils;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpException;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Properties;
import lombok.SneakyThrows;
/**
 * @author Administrator
 */
public class SftpUtil {

  /**
   * @param userName 用户名
   * @param password 密码
   * @param host ip
   * @param port 端口
   * @param basePath 根路径
   * @param filePath 文件路径（加上根路径）
   * @param filename 文件名
   * @param privateKey 秘钥
   * @param input 文件流 @Author: jinhaoxun @Description: 下载文件 @Date: 2020-9-29 18:05:39 @Return:
   *     void @Throws: Exception
   */
  public static void uploadFile(
      String userName,
      String password,
      String host,
      int port,
      String basePath,
      String filePath,
      String filename,
      String privateKey,
      InputStream input)
      throws Exception {

    Session session = null;
    ChannelSftp sftp = null;
    // 连接sftp服务器
    try {
      JSch jsch = new JSch();
      if (privateKey != null) {
        // 设置私钥
        jsch.addIdentity(privateKey);
      }

      session = jsch.getSession(userName, host, port);

      if (password != null) {
        session.setPassword(password);
      }
      Properties config = new Properties();
      config.put("StrictHostKeyChecking", "no");

      session.setConfig(config);
      session.connect();

      Channel channel = session.openChannel("sftp");
      channel.connect();

      sftp = (ChannelSftp) channel;
    } catch (JSchException e) {
      e.printStackTrace();
    }
    // 将输入流的数据上传到sftp作为文件
    try {
      sftp.cd(basePath);
      sftp.cd(filePath);
    } catch (SftpException e) {
      // 目录不存在，则创建文件夹
      String[] dirs = filePath.split("/");
      String tempPath = basePath;
      for (String dir : dirs) {
        if (null == dir || "".equals(dir)) {
          continue;
        }
        tempPath += "/" + dir;
        try {
          sftp.cd(tempPath);
        } catch (SftpException ex) {
          sftp.mkdir(tempPath);
          sftp.cd(tempPath);
        }
      }
    }
    // 上传文件
    sftp.put(input, filename);
    // 关闭连接 server
    if (sftp != null) {
      if (sftp.isConnected()) {
        sftp.disconnect();
      }
    }
    // 关闭连接 server
    if (session != null) {
      if (session.isConnected()) {
        session.disconnect();
      }
    }
  }

  // 案例-----↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓-------------

  @SneakyThrows
  public static void main(String[] args) {
    File file = new File("D:\\1.txt");
    InputStream inputStream = new FileInputStream(file);

    SftpUtil.uploadFile(
        "canal", "canal", "192.168.25.9", 22, "/root", "/testFile/", "test.txt", null, inputStream);
  }
}
