package com.devplatform.equipment.common.utils;

import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
/**
 * @author Administrator
 */
public class SimpleMailSender {

  /**
   * 以HTML格式发送邮件
   *
   * @param mailInfo 待发送的邮件信息
   */
  public static boolean sendHtmlMail(MailSenderInfo mailInfo) {
    // 判断是否需要身份认证
    MyAuthenticator authenticator = null;
    Properties pro = mailInfo.getProperties();
    // 如果需要身份认证，则创建一个密码验证器
    if (mailInfo.isValidate()) {
      authenticator = new MyAuthenticator(mailInfo.getUserName(), mailInfo.getPassword());
    }
    // 根据邮件会话属性和密码验证器构造一个发送邮件的session
    Session sendMailSession = Session.getDefaultInstance(pro, authenticator);
    try {
      // 根据session创建一个邮件消息
      Message mailMessage = new MimeMessage(sendMailSession);
      // 创建邮件发送者地址
      Address from = new InternetAddress(mailInfo.getFromAddress());
      // 设置邮件消息的发送者
      mailMessage.setFrom(from);

      // 设置自定义发件人昵称
      String nick = "";
      try {
        nick = javax.mail.internet.MimeUtility.encodeText(mailInfo.getFromName());
      } catch (UnsupportedEncodingException e) {
        e.printStackTrace();
      }
      mailMessage.setFrom(new InternetAddress(nick + " <" + from + ">"));

      // 发送多人
      if (mailInfo.getToAddress().indexOf(Constants.SYMBOL_SEMICOLON) > -1) {
        String[] toAllAddress = mailInfo.getToAddress().split(";");
        InternetAddress[] address = new InternetAddress[toAllAddress.length];
        for (int i = 0; i < toAllAddress.length; i++) {
          address[i] = new InternetAddress(toAllAddress[i]);
        }
        mailMessage.setRecipients(Message.RecipientType.TO, address);
      } else {
        // 创建邮件的接收者地址，并设置到邮件消息中
        Address to = new InternetAddress(mailInfo.getToAddress());
        // Message.RecipientType.TO属性表示接收者的类型为TO
        mailMessage.setRecipient(Message.RecipientType.TO, to);
      }

      // 发送抄送人
      if (mailInfo.getCcAddress() != null && !"".equals(mailInfo.getCcAddress())) {
        if (mailInfo.getCcAddress().indexOf(Constants.SYMBOL_SEMICOLON) > -1) {

          String[] toAllCcAddress = mailInfo.getCcAddress().split(";");
          InternetAddress[] address = new InternetAddress[toAllCcAddress.length];
          for (int i = 0; i < toAllCcAddress.length; i++) {
            address[i] = new InternetAddress(toAllCcAddress[i]);
          }
          mailMessage.setRecipients(Message.RecipientType.CC, address);
        } else {
          Address cc = new InternetAddress(mailInfo.getCcAddress());
          // Message.RecipientType.CC属性表示接收者的类型为CC
          mailMessage.setRecipient(Message.RecipientType.CC, cc);
        }
      }
      // 设置邮件消息的主题
      mailMessage.setSubject(mailInfo.getSubject());
      // 设置邮件消息发送的时间
      mailMessage.setSentDate(new Date());
      // MiniMultipart类是一个容器类，包含MimeBodyPart类型的对象
      Multipart mainPart = new MimeMultipart();
      // 创建一个包含HTML内容的MimeBodyPart
      BodyPart html = new MimeBodyPart();
      // 设置HTML内容
      html.setContent(mailInfo.getContent(), "text/html; charset=utf-8");
      mainPart.addBodyPart(html);
      // 将MiniMultipart对象设置为邮件内容
      mailMessage.setContent(mainPart);
      // 发送邮件
      Transport.send(mailMessage);
      return true;
    } catch (MessagingException ex) {
      ex.printStackTrace();
    }
    return false;
  }

  /**
   * 以文本格式发送邮件
   *
   * @param mailInfo 待发送的邮件的信息
   */
  public boolean sendTextMail(MailSenderInfo mailInfo) {
    // 判断是否需要身份认证
    MyAuthenticator authenticator = null;
    Properties pro = mailInfo.getProperties();
    if (mailInfo.isValidate()) {
      // 如果需要身份认证，则创建一个密码验证器
      authenticator = new MyAuthenticator(mailInfo.getUserName(), mailInfo.getPassword());
    }
    // 根据邮件会话属性和密码验证器构造一个发送邮件的session
    Session sendMailSession = Session.getDefaultInstance(pro, authenticator);
    try {
      // 根据session创建一个邮件消息
      Message mailMessage = new MimeMessage(sendMailSession);
      // 创建邮件发送者地址
      Address from = new InternetAddress(mailInfo.getFromAddress());
      // 设置邮件消息的发送者
      mailMessage.setFrom(from);
      // 创建邮件的接收者地址，并设置到邮件消息中
      Address to = new InternetAddress(mailInfo.getToAddress());
      mailMessage.setRecipient(Message.RecipientType.TO, to);
      // 设置邮件消息的主题
      mailMessage.setSubject(mailInfo.getSubject());
      // 设置邮件消息发送的时间
      mailMessage.setSentDate(new Date());
      // 设置邮件消息的主要内容
      String mailContent = mailInfo.getContent();
      mailMessage.setText(mailContent);
      // 发送邮件
      Transport.send(mailMessage);
      return true;
    } catch (MessagingException ex) {
      ex.printStackTrace();
    }
    return false;
  }
}
