package com.devplatform.equipment.common.utils;

import java.util.Locale;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
/**
 * @author Administrator
 */
public class SpringContextUtil implements ApplicationContextAware {

  private static ApplicationContext applicationContext = null;

  public static <T> T getBean(String beanName) {
    return (T) applicationContext.getBean(beanName);
  }

  public static Object getBean(Class c) {
    if (applicationContext == null) {
      return null;
    }
    return applicationContext.getBean(c);
  }

  public static String getMessage(String key) {
    return applicationContext.getMessage(key, null, Locale.getDefault());
  }

  @Override
  public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
    SpringContextUtil.applicationContext = applicationContext;
  }
}
