package com.devplatform.equipment.config;

import java.io.IOException;
import java.util.Collection;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.http.HttpHeaders;
import org.springframework.stereotype.Component;

/**
 * 解决检测到会话 cookie 中缺少 HttpOnly 属性
 *
 * @author admin
 */
@Component
public class CookieHttpOnlyFilter implements Filter {

  public String forwardUrl = "/index.html";
  public FilterConfig config;

  @Override
  public void destroy() {
    this.config = null;
  }

  @Override
  public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain)
      throws IOException, ServletException {

    HttpServletRequest req = (HttpServletRequest) request;
    HttpServletResponse resp = (HttpServletResponse) response;
    // 2、对session和cookie设置httpOnly属性
    Cookie[] cookies = req.getCookies();
    if (cookies != null) {
      for (Cookie cookie : cookies) {
        cookie.setHttpOnly(true);
        cookie.setSecure(true);
      }
    }
    // 设置HttpOnley属性
    resp.setHeader("Set-Cookie", "name=value; HttpOnly;Samesite=Strict");
    // add SameSite=strict cookie attribute
    addSameSiteCookieAttribute(resp);

    filterChain.doFilter(new MyHttpServletRequest(req), resp);

  }

  /**
   * 设置cookie的属性
   */
  public void addSameSiteCookieAttribute(HttpServletResponse response) {
    Collection<String> headers = response.getHeaders(HttpHeaders.SET_COOKIE);
    boolean firstHeader = true;
    for (String header : headers) {
      if (firstHeader) {
        response.setHeader(HttpHeaders.SET_COOKIE, String.format("%s; %s", header, "SameSite=Strict"));
        firstHeader = false;
        continue;
      }
      response.addHeader(HttpHeaders.SET_COOKIE, String.format("%s; %s", header, "SameSite=Strict"));
    }
  }

  @Override
  public void init(FilterConfig arg0) throws ServletException {
    this.config = arg0;
  }

  public String getForwardUrl() {
    return forwardUrl;
  }

  public void setForwardUrl(String forwardUrl) {
    this.forwardUrl = forwardUrl;
  }

}
