package com.devplatform.equipment.config;
import com.devplatform.equipment.common.utils.Constants;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * 请求过滤crsf
 *
 * @author Administrator
 */
public class CosrFilter implements Filter {

  private String[] verifyReferer = null;

  @Override
  public void destroy() {

  }

  @Override
  public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain)
      throws IOException, ServletException {

    HttpServletRequest httpServletRequest = (HttpServletRequest) request;
    HttpServletResponse httpServletResponse = (HttpServletResponse) response;
    String referer = httpServletRequest.getHeader("Referer");
    boolean b = false;
    for (String vReferer : verifyReferer) {
      if (referer == null || referer.trim().startsWith(vReferer)) {
        b = true;
        chain.doFilter(request, response);
        break;
      }
    }
    if (!b) {
      System.out.println("疑似CSRF攻击，referer:" + referer);

      //继续判断请求头 获取请求方式
      String method = httpServletRequest.getMethod();
      //判断是否包含TRACE或TRACK请求
      if (Constants.TRACE.equals(method) || Constants.TRACK.equals(method)) {
        httpServletResponse.setHeader("Allow", "HEAD, DELETE, POST, GET, OPTIONS, PUT");
        httpServletResponse.setStatus(405);
        return;
      }
      chain.doFilter(request, response);
    }
  }

  @Override
  public void init(FilterConfig filterConfig) throws ServletException {
    String referer = filterConfig.getInitParameter("referer");
    this.verifyReferer = referer.split(",");
  }

}
