package com.devplatform.equipment.feign.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import java.io.Serializable;
import java.util.Date;

/**
 * 系统日志
 *
 * @author chenshun
 * @email sunlightcs@gmail.com
 * @date 2017-03-08 10:40:56
 */
@TableName("sys_log")
public class SysLogEntity implements Serializable {
  private static final long serialVersionUID = 1L;
  @TableId private String id;
  /** 用户id*/
  private String userId;
  /** 机构id*/
  private String orgId;
  /** 用户名*/
  private String username;
  /** 操作类型（登录、注销、新增、修改、删除）*/
  private String operation;
  /** 描述*/
  private String detail;
  /** 模块名称*/
  private String blockName;
  /** 请求方法*/
  private String method;
  /** 请求参数*/
  private String params;
  /** 执行时长(毫秒)*/
  private Long time;
  /** IP地址*/
  private String ip;
  /** 系统标识*/
  private String sysSign;
  /** 站点id*/
  private String stationId;
  /** 创建时间*/
  private Date createDate;
  /** 创建时间*/
  private String createBy;

  @TableField(exist = false)
  private String startTime;

  @TableField(exist = false)
  private String endTime;

  @TableField(exist = false)
  private String orgName;

  public String getStationId() {
    return stationId;
  }

  public void setStationId(String stationId) {
    this.stationId = stationId;
  }

  public String getOrgName() {
    return orgName;
  }

  public void setOrgName(String orgName) {
    this.orgName = orgName;
  }

  public String getStartTime() {
    return startTime;
  }

  public void setStartTime(String startTime) {
    this.startTime = startTime;
  }

  public String getEndTime() {
    return endTime;
  }

  public void setEndTime(String endTime) {
    this.endTime = endTime;
  }

  public String getOrgId() {
    return orgId;
  }

  public void setOrgId(String orgId) {
    this.orgId = orgId;
  }

  public String getUserId() {
    return userId;
  }

  public void setUserId(String userId) {
    this.userId = userId;
  }

  public String getDetail() {
    return detail;
  }

  public void setDetail(String detail) {
    this.detail = detail;
  }

  public String getBlockName() {
    return blockName;
  }

  public void setBlockName(String blockName) {
    this.blockName = blockName;
  }

  public String getSysSign() {
    return sysSign;
  }

  public void setSysSign(String sysSign) {
    this.sysSign = sysSign;
  }

  /** 获取： */
  public String getId() {
    return id;
  }

  /** 设置： */
  public void setId(String id) {
    this.id = id;
  }

  /** 获取：用户名 */
  public String getUsername() {
    return username;
  }

  /** 设置：用户名 */
  public void setUsername(String username) {
    this.username = username;
  }

  /** 获取：用户操作 */
  public String getOperation() {
    return operation;
  }

  /** 设置：用户操作 */
  public void setOperation(String operation) {
    this.operation = operation;
  }

  /** 获取：请求方法 */
  public String getMethod() {
    return method;
  }

  /** 设置：请求方法 */
  public void setMethod(String method) {
    this.method = method;
  }

  /** 获取：请求参数 */
  public String getParams() {
    return params;
  }

  /** 设置：请求参数 */
  public void setParams(String params) {
    this.params = params;
  }

  /** 获取：IP地址 */
  public String getIp() {
    return ip;
  }

  /** 设置：IP地址 */
  public void setIp(String ip) {
    this.ip = ip;
  }

  /** 获取：创建时间 */
  public Date getCreateDate() {
    return createDate;
  }

  /** 设置：创建时间 */
  public void setCreateDate(Date createDate) {
    this.createDate = createDate;
  }

  public Long getTime() {
    return time;
  }

  public void setTime(Long time) {
    this.time = time;
  }

  public String getCreateBy() {
    return createBy;
  }

  public void setCreateBy(String createBy) {
    this.createBy = createBy;
  }
}
