package com.devplatform.equipment.feign.service;

import com.devplatform.equipment.feign.config.FeignConfig;
import java.util.List;
import java.util.Map;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * @author Administrator
 */
@FeignClient(value = "microservice-admin", configuration = FeignConfig.class)
public interface AdminService {

  /**
   * 获取当前登陆人ID
   *
   * @return
   */
  @RequestMapping(value = "/sys/getCurrentUserInfo", method = RequestMethod.POST)
  String getCurrentUserInfo();

  /**
   * 获取当前登陆人信息
   *
   * @return
   */
  @RequestMapping(value = "/sys/getCurrentUserBeanInfo", method = RequestMethod.POST)
  String getCurrentUserBeanInfo();

  /**
   * 根据用户ID查询用户信息
   * @param userId
   * @return
   */
  @RequestMapping(value = "/sys/user/info/{userId}", method = RequestMethod.GET)
  String info(@PathVariable("userId") String userId);

  /**
   * 根据专管员的姓名集合查询专管员信息不带分页
   * @param nameList
   * @return
   */
  @RequestMapping(value = "/sys/user/majorManagerListNoPage", method = RequestMethod.POST)
  String majorManagerListNoPage(List<String> nameList);

  /**
   * 根据角色id查询角色信息
   * @param roleId
   * @return
   */
  @RequestMapping(value = "/sys/role/info/{roleId}", method = RequestMethod.GET)
  String roleInfo(@RequestParam("roleId") String roleId);

  /**
   * 发送报警信息到websocket
   * @param params
   */
  @RequestMapping(value = "/alramsSend/sendAlramsInfo", method = RequestMethod.GET)
  void sendAlramsInfo(@RequestParam Map<String, Object> params);
}
