package com.devplatform.equipment.feign.service;

import com.devplatform.equipment.feign.config.FeignConfig;
import java.util.List;
import java.util.Map;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * @author Administrator
 */
@FeignClient(value = "microservice-alram", configuration = FeignConfig.class)
public interface AlarmsService {
  /**
   * 保存报警文件
   * @param imageName
   * @param imagePath
   * @param snapName
   * @param snapPath
   * @param id
   * @param sysSign
   * @param stationId
   */
  @RequestMapping(value = "/alarmAttachment/saveAttachment", method = RequestMethod.POST)
  void saveAttachment(
      @RequestParam("imageName") String imageName,
      @RequestParam("imagePath") String imagePath,
      @RequestParam("snapName") String snapName,
      @RequestParam("snapPath") String snapPath,
      @RequestParam("id") String id,
      @RequestParam("sysSign") String sysSign,
      @RequestParam("stationId") String stationId);

  /**
   * 查询报警文件
   * @param alarmsId
   * @param stationId
   * @return
   */
  @RequestMapping(value = "/alarmAttachment/getList", method = RequestMethod.POST)
  List<Map<String, Object>> getList(
      @RequestParam("alarmsId") String alarmsId, @RequestParam("stationId") String stationId);
}
