package com.devplatform.equipment.feign.service;

import com.devplatform.equipment.feign.config.FeignConfig;
import java.util.HashMap;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * @author Administrator
 */
@FeignClient(value = "microservice-alram", configuration = FeignConfig.class)
public interface LinkService {

  /**
   * 查询联动规则数据
   * @param resourceId
   * @param stationId
   * @return
   */
  @RequestMapping(path = "/linkLinkageRule/getLinkRule", method = RequestMethod.GET)
  public List<HashMap<String, Object>> getLinkRule(
      @RequestParam("resourceId") String resourceId, @RequestParam("stationId") String stationId);
}
