package com.devplatform.equipment.modules.accesscard.controller;

import com.devplatform.common.util.R;
import com.devplatform.common.util.StringUtil;
import com.devplatform.equipment.common.utils.AbstractController;
import com.devplatform.equipment.common.utils.Constants;
import com.devplatform.equipment.common.utils.MyPage;
import com.devplatform.equipment.modules.accesscard.bean.AccessCard;
import com.devplatform.equipment.modules.accesscard.model.AccessCardModel;
import com.devplatform.equipment.modules.accesscard.service.AccessCardService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import sun.misc.BASE64Encoder;
/**
 * @author Administrator
 */
@Api(tags = {"出入卡管理接口"})
@RestController
@RequestMapping("/accessCard")
public class AccessCardController extends AbstractController {

  @Autowired private AccessCardService accessCardService;

  /**
   * 列表页面列表数据获取
   *
   * @param params 承接对象 page 页码 rows 每页条数 stationId 站点id name 姓名 serialNumber 卡序列号 jobNumber 工号 sort
   *     排序字段
   * @return
   */
  @ApiOperation(value = "根据条件获取出入卡管理分页数据列表", notes = "根据条件获取出入卡管理分页数据列表")
  @ApiImplicitParam(
      name = "params",
      value = "参数",
      required = true,
      dataType = "Map<String, String>")
  @PostMapping("/list")
  public R list(@RequestBody Map<String, String> params) {
    AccessCardModel model = new AccessCardModel();
    // 页码
    String page = params.get("page");
    if (StringUtil.checkNotNull(page)) {
      model.setPage(Integer.parseInt(page));
    }
    // 每页条数
    String rows = params.get("rows");
    if (StringUtil.checkNotNull(rows)) {
      model.setRows(Integer.parseInt(rows));
    }
    // 站点id
    String stationId = params.get("stationId");
    if (StringUtil.checkNotNull(stationId)) {
      model.setStationId(stationId);
    }
    // 姓名
    String name = params.get("name");
    if (StringUtil.checkNotNull(name)) {
      model.setName(name);
    }
    // 排序条件
    String sort = params.get("sort");
    if (StringUtils.isBlank(model.getSort())) {
      model.setSort(sort);
    }
    String order = params.get("order");
    if (StringUtils.isBlank(model.getOrder())) {
      model.setOrder(order);
    }
    List<AccessCard> list = accessCardService.queryPageByList(model);
    return R.ok().put("page", getMyPage(list, model));
  }

  /**
   * * stationId 站点id name 姓名 serialNumber 卡序列号 jobNumber 工号 sort 排序字段
   *
   * @return
   */
  @ApiOperation(value = "根据条件导出出入卡管理数据excel文件", notes = "根据条件导出出入卡管理数据excel文件")
  @GetMapping("/export")
  public void export(String stationId,String name,String serialNumber,String jobNumber,
      String sort,HttpServletRequest request,HttpServletResponse rep) {
    HashMap<String, String> params = new HashMap<>(10);
    params.put("stationId", stationId);
    params.put("name", name);
    params.put("serialNumber", serialNumber);
    params.put("jobNumber", jobNumber);
    params.put("sort", sort);
    // 获取到需要导出的数据
    List<AccessCard> accessCardList = (List<AccessCard>) ((MyPage) list(params).get("page")).getRows();
    OutputStream os = null;
    try {
      /** 取得输出流 */
      os = rep.getOutputStream();
      /** 清空输出流 */
      rep.reset();
      rep.setHeader("Access-Control-Expose-Headers", "Content-Disposition");
      String fileName = "发卡记录.xlsx";
      String userAgent = request.getHeader("USER-AGENT");
      if (userAgent.contains(Constants.FIREFOX)) {
        // 是火狐浏览器，使用BASE64编码
        fileName = "=?utf-8?b?" + new BASE64Encoder().encode(fileName.getBytes("utf-8")) + "?=";
      } else {
        // 给文件名进行URL编码 URLEncoder.encode()需要两个参数，第一个参数时要编码的字符串，第二个是编码所采用的字符集
        fileName = URLEncoder.encode(fileName, "utf-8");
      }
      rep.setHeader("Content-disposition", "attachment;fileName=" + fileName);
      /** 设定输出文件头,输出类型 */
      rep.setContentType("application/msexcel");
      XSSFWorkbook workbook = new XSSFWorkbook();

      // 创建单元格样式
      XSSFCellStyle cellStyle = workbook.createCellStyle();
      cellStyle.setAlignment(HorizontalAlignment.CENTER);
      XSSFSheet sheet = workbook.createSheet("1");
      XSSFRow firstRow = sheet.createRow(0);
      firstRow.createCell(0).setCellValue("序号");
      firstRow.createCell(1).setCellValue("姓名");
      firstRow.createCell(2).setCellValue("卡序列号");
      firstRow.createCell(3).setCellValue("创建时间");
      firstRow.createCell(4).setCellValue("起始有效时间");
      firstRow.createCell(5).setCellValue("结束有效时间");
      int index = 1;
      SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
      for (AccessCard accessCard : accessCardList) {
        XSSFRow row = sheet.createRow(index);
        row.createCell(0).setCellValue(index);
        row.createCell(1).setCellValue(accessCard.getName());
        row.createCell(2).setCellValue(accessCard.getSerialNumber());
        row.createCell(3).setCellValue(sdf.format(accessCard.getCreateTime()));
        row.createCell(4).setCellValue(sdf.format(accessCard.getActivation()));
        row.createCell(5).setCellValue(sdf.format(accessCard.getExpiration()));
        index++;
      }
      // 设置单元格样式
      for (int i = 0; i < sheet.getPhysicalNumberOfRows(); i++) {
        XSSFRow row = sheet.getRow(i);
        for (int j = 0; j < row.getPhysicalNumberOfCells(); j++) {
          row.getCell(j).setCellStyle(cellStyle);
        }
      }
      for (int i = 0; i < firstRow.getPhysicalNumberOfCells(); i++) {
        // 设置列宽自适应
        sheet.autoSizeColumn(i);
        sheet.setColumnWidth(i, sheet.getColumnWidth(i) * 17 / 10);
      }
      workbook.write(os);
      os.flush();
    } catch (Exception e) {
      e.printStackTrace();
    } finally {
      if (os != null) {
        try {
          os.close();
        } catch (IOException e) {
          e.printStackTrace();
        }
      }
    }
  }

  /**
   * 发卡同步 从门禁系统中，SQL Sever数据库，同步发卡数据，一个人可同时拥有多张卡
   *
   * @return
   */
  @ApiOperation(value = "根据条件获取出入卡管理分页数据列表", notes = "根据条件获取出入卡管理分页数据列表")
  @ApiImplicitParam(
      name = "params",
      value = "参数",
      required = true,
      dataType = "Map<String, String>")
  @PostMapping("/sync")
  public R sync() {

    String driverName = "com.microsoft.sqlserver.jdbc.SQLServerDriver";
    // 加载JDBC驱动
    String dburl = "jdbc:sqlserver://10.20.72.29:1433; DatabaseName=SchlageSQL";
    // 连接服务器和数据库
	// 默认用户名
    String userName = "test";
	// 密码
    String userPwd = "123456";
    Connection dbConn = null;
    try {
      System.out.println("11111!");
      Class.forName(driverName);
      System.out.println("2222!");
      dbConn = DriverManager.getConnection(dburl, userName, userPwd);
	// 如果连接成功 控制台输出Connection Successful!
      System.out.println("Connection Successful!");
      // 连接成功的同时，删除现有数据库中所有发卡表数据
      accessCardService.deleteAll();
    } catch (Exception e) {
      System.out.println("Connection SqlServer 连接失败！！！");
      e.printStackTrace();
      return R.error("同步失败！请检查网络是否正常！");
    }

    Statement sql;
    ResultSet rs;
    try {
      sql = dbConn.createStatement();
      // SQL查询语句
      rs =
          sql.executeQuery(
              "select c.LastName,b.EncodedID,b.CreateDate,c.Activation,c.Expiration from ActiveBadge ab "
                  + "left join badge b on b.BadgeID = ab.BadgeID "
                  + "left join Cardholder c on ab.CardholderID = c.CardholderID");
      int p = 1;
      while (rs.next()) {
        System.out.println(p);
        p++;
        // 卡ID
        String cardholderId = rs.getString(1);
        // 打印number列
        System.out.printf("%s\t", cardholderId);

        AccessCard ac = new AccessCard();
        // 持卡人姓名
        String name = rs.getString(1);
        ac.setName(name);
        // 卡序列号
        String serialNumber = rs.getString(2);
        ac.setSerialNumber(serialNumber);
        // 创建时间
        Date createTime = rs.getDate(3);
        ac.setCreateTime(createTime);
        // 起始有效时间
        Date activation = rs.getDate(4);
        ac.setActivation(activation);
        // 起始有效时间
        Date expiration = rs.getDate(5);
        ac.setExpiration(expiration);
        // 站点ID
        ac.setStationId(getUser().getSysSystem().getCode());
        // 当前系统标识ID
        ac.setSysSign(getUser().getSysSystem().getCode());
        accessCardService.save(ac);
      }
      dbConn.close();
      return R.ok();
    } catch (SQLException e) {
      System.out.println("Connection SqlServer 读取门禁发卡表数据失败！！！");
      System.out.println(e);
      return R.error("同步失败！请检查网络是否正常！");
    }
  }
}
