package com.devplatform.equipment.modules.accesscard.dao;

import com.devplatform.common.dao.MyBaseMapper;
import com.devplatform.equipment.modules.accesscard.bean.AccessCard;
import com.devplatform.equipment.modules.accesscard.model.AccessCardModel;
import java.util.List;
import org.apache.ibatis.annotations.Mapper;
import org.springframework.stereotype.Repository;

/**
 * AccessCard Mapper 用于出入卡管理的数据库操作
 *
 * @author Administrator
 */
@Mapper
@Repository
public interface AccessCardDao extends MyBaseMapper<AccessCard> {

  /**
   * 查询发卡数量
   * @param model
   * @return
   */
  Integer queryPageByCount(AccessCardModel model);

  /**
   * 查询发卡分页数据
   * @param model
   * @return
   */
  List<AccessCard> queryPageByList(AccessCardModel model);

  /**
   * 删除全部
   */
  void deleteAll();
}
