package com.devplatform.equipment.modules.alarms.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.devplatform.equipment.modules.link.log.bean.LinkAttachment;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import org.springframework.format.annotation.DateTimeFormat;

/**
 * @author Administrator
 */
@ApiModel(value = "报警信息对象", description = "报警信息对象")
@TableName("alarms_info")
public class AlarmsInfo implements Serializable {
  private static final long serialVersionUID = 1L;

  @ApiModelProperty(value = "主键ID", name = "id")
  @TableId
	/** 主键*/
  private String id; 

  @ApiModelProperty(value = "子系统id(数据字典维护)", name = "systemId")
	/** 子系统id(数据字典维护)*/
  private String systemId; 

  @ApiModelProperty(value = "事件编号", name = "eventNumber")
	/** 事件编号*/
  private String eventNumber; 

  @ApiModelProperty(value = "事件名称", name = "eventName")
	/** 事件名称*/
  private String eventName; 

  @ApiModelProperty(value = "事件类型 1:黑名单 2:周界入侵 3:出入口非法闯入 4:炸探 5:液探 6: 一键报警", name = "eventType")
  private String eventType;

  @ApiModelProperty(value = "事件等级 1:特别重大,2:重大,3:一般", name = "eventLevel")
	/** 事件等级 1:特别重大,2:重大,3:一般*/
  private Integer eventLevel; 

  @ApiModelProperty(value = "资源id", name = "resourceId")
	/** 资源id*/
  private String resourceId; 

  @ApiModelProperty(value = "资源名称", name = "resourceName")
	/** 资源名称*/
  private String resourceName; 

  @ApiModelProperty(value = "发生时间", name = "occurrenceTime")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	/** 发生时间*/
  private java.util.Date occurrenceTime; 

  @ApiModelProperty(value = "发生地点", name = "occurrenceSite")
	/** 发生地点*/
  private String occurrenceSite; 

  @ApiModelProperty(value = "状态：1:未处理, 2:处理中,3:已处理", name = "status")
	/** 处理状态：1:未处理, 2:处理中,3:已处理*/
  private Integer status; 

  @ApiModelProperty(value = "处理报警时的处理状态：1：处理完毕 2：待继续处理", name = "alarmsStatus")
	/** 报警处理状态：1：处理完毕 2：待继续处理*/
  private Integer alarmsStatus; 

  @ApiModelProperty(value = "处理方式（1：处理事件 2：应急预案）", name = "type")
	/** 处理方式（1：处理事件 2：应急预案）*/
  private Integer type; 

  @ApiModelProperty(value = "预案登记id", name = "planId")
	/** 预案登记id*/
  private String planId; 

  @ApiModelProperty(value = "创建时间", name = "createTime")
	/** 创建时间*/
  private java.util.Date createTime; 

  @ApiModelProperty(value = "创建人", name = "createUserId")
	/** 创建人*/
  private String createUserId; 

  @ApiModelProperty(value = "修改时间", name = "updateTime")
	/** 修改时间*/
  private java.util.Date updateTime; 

  @ApiModelProperty(value = "修改人", name = "updateUserId")
	/** 修改人*/
  private String updateUserId; 

  @ApiModelProperty(value = "是否已删除（0未删除，1已删除）", name = "deleted")
	/** 是否已删除（0未删除，1已删除）*/
  private Integer deleted; 

  @ApiModelProperty(value = "备注1", name = "byx1")
	/** 备注1*/
  private String byx1; 

  @ApiModelProperty(value = "备注2", name = "byx2")
	/** 备注2*/
  private String byx2; 

  @ApiModelProperty(value = "备注3", name = "byx3")
	/** 备注3*/
  private String byx3; 

  @ApiModelProperty(value = "系统标识", name = "sysSign")
  private String sysSign;

  @ApiModelProperty(value = "系统标识", name = "stationId")
  private String stationId;

  @TableField(exist = false)
	/** 事件等级特别重大数量*/
  private Integer oneCount; 

  @TableField(exist = false)
	/** 事件等级重大数量*/
  private Integer twoCount; 

  @TableField(exist = false)
	/** 事件等级一般数量*/
  private Integer threeCount; 

  @TableField(exist = false)
	/** 子系统名称*/
  private String systemName; 

  @TableField(exist = false)
	/** 处理意见*/
  private String content; 

  @TableField(exist = false)
	/** 站点名*/
  private String stationName; 

  @TableField(exist = false)
	/** 站层名*/
  private String tierName; 

  @TableField(exist = false)
  private LinkAttachment fj;

  @TableField(exist = false)
  private AlarmsAttachment hmdfj;

  @TableField(exist = false)
  private String path;

  @TableField(exist = false)
  private Boolean beSend = false;

  @TableField(exist = false)
  /** 资源点编码*/
  private String resourceCode;

  @TableField(exist = false)
  /** 报警类型名称 */
  private String eventTypeName;

  @TableField(exist = false)
  /** 线路id */
  private String lineId;

  public String getLineId() {
    return lineId;
  }

  public void setLineId(String lineId) {
    this.lineId = lineId;
  }

  public String getResourceCode() {
    return resourceCode;
  }

  public void setResourceCode(String resourceCode) {
    this.resourceCode = resourceCode;
  }

  public String getPath() {
    return path;
  }

  public void setPath(String path) {
    this.path = path;
  }

  public AlarmsAttachment getHmdfj() {
    return hmdfj;
  }

  public void setHmdfj(AlarmsAttachment hmdfj) {
    this.hmdfj = hmdfj;
  }

  public String getSysSign() {
    return sysSign;
  }

  public void setSysSign(String sysSign) {
    this.sysSign = sysSign;
  }

  public Boolean getBeSend() {
    return beSend;
  }

  public void setBeSend(Boolean beSend) {
    this.beSend = beSend;
  }

  public String getStationName() {
    return stationName;
  }

  public void setStationName(String stationName) {
    this.stationName = stationName;
  }

  public String getTierName() {
    return tierName;
  }

  public void setTierName(String tierName) {
    this.tierName = tierName;
  }

  public String getContent() {
    return content;
  }

  public void setContent(String content) {
    this.content = content;
  }

  public String getSystemName() {
    return systemName;
  }

  public void setSystemName(String systemName) {
    this.systemName = systemName;
  }

  public Integer getOneCount() {
    return oneCount;
  }

  public void setOneCount(Integer oneCount) {
    this.oneCount = oneCount;
  }

  public Integer getTwoCount() {
    return twoCount;
  }

  public void setTwoCount(Integer twoCount) {
    this.twoCount = twoCount;
  }

  public Integer getThreeCount() {
    return threeCount;
  }

  public void setThreeCount(Integer threeCount) {
    this.threeCount = threeCount;
  }

  /** 主键的getter方法 */
  public String getId() {
    return id;
  }
  /** 主键的setter方法 */
  public void setId(String id) {
    this.id = id;
  }

  public String getSystemId() {
    return systemId;
  }

  public void setSystemId(String systemId) {
    this.systemId = systemId;
  }

  public Integer getAlarmsStatus() {
    return alarmsStatus;
  }

  public void setAlarmsStatus(Integer alarmsStatus) {
    this.alarmsStatus = alarmsStatus;
  }

  /** 事件编号的getter方法 */
  public String getEventNumber() {
    return eventNumber;
  }
  /** 事件编号的setter方法 */
  public void setEventNumber(String eventNumber) {
    this.eventNumber = eventNumber;
  }
  /** 事件名称的getter方法 */
  public String getEventName() {
    return eventName;
  }
  /** 事件名称的setter方法 */
  public void setEventName(String eventName) {
    this.eventName = eventName;
  }
  /** 事件类型 1:危险品报警,2:打卡异常,3:入侵报警,4:黑名单的getter方法 */
  public String getEventType() {
    return eventType;
  }
  /** 事件类型 1:危险品报警,2:打卡异常,3:入侵报警,4:黑名单的setter方法 */
  public void setEventType(String eventType) {
    this.eventType = eventType;
  }
  /** 事件等级 1:特别重大,2:重大,3:一般的getter方法 */
  public Integer getEventLevel() {
    return eventLevel;
  }
  /** 事件等级 1:特别重大,2:重大,3:一般的setter方法 */
  public void setEventLevel(Integer eventLevel) {
    this.eventLevel = eventLevel;
  }
  /** 资源id的getter方法 */
  public String getResourceId() {
    return resourceId;
  }
  /** 资源id的setter方法 */
  public void setResourceId(String resourceId) {
    this.resourceId = resourceId;
  }
  /** 资源名称的getter方法 */
  public String getResourceName() {
    return resourceName;
  }
  /** 资源名称的setter方法 */
  public void setResourceName(String resourceName) {
    this.resourceName = resourceName;
  }
  /** 发生时间的getter方法 */
  public java.util.Date getOccurrenceTime() {
    return occurrenceTime;
  }
  /** 发生时间的setter方法 */
  public void setOccurrenceTime(java.util.Date occurrenceTime) {
    this.occurrenceTime = occurrenceTime;
  }
  /** 发生地点的getter方法 */
  public String getOccurrenceSite() {
    return occurrenceSite;
  }
  /** 发生地点的setter方法 */
  public void setOccurrenceSite(String occurrenceSite) {
    this.occurrenceSite = occurrenceSite;
  }
  /** 处理状态：1:未处理, 2:处理中,3:已处理的getter方法 */
  public Integer getStatus() {
    return status;
  }
  /** 处理状态：1:未处理, 2:处理中,3:已处理的setter方法 */
  public void setStatus(Integer status) {
    this.status = status;
  }
  /** 创建时间的getter方法 */
  public java.util.Date getCreateTime() {
    return createTime;
  }
  /** 创建时间的setter方法 */
  public void setCreateTime(java.util.Date createTime) {
    this.createTime = createTime;
  }
  /** 创建人的getter方法 */
  public String getCreateUserId() {
    return createUserId;
  }
  /** 创建人的setter方法 */
  public void setCreateUserId(String createUserId) {
    this.createUserId = createUserId;
  }
  /** 修改时间的getter方法 */
  public java.util.Date getUpdateTime() {
    return updateTime;
  }
  /** 修改时间的setter方法 */
  public void setUpdateTime(java.util.Date updateTime) {
    this.updateTime = updateTime;
  }
  /** 修改人的getter方法 */
  public String getUpdateUserId() {
    return updateUserId;
  }
  /** 修改人的setter方法 */
  public void setUpdateUserId(String updateUserId) {
    this.updateUserId = updateUserId;
  }
  /** 是否已删除（0未删除，1已删除）的getter方法 */
  public Integer getDeleted() {
    return deleted;
  }
  /** 是否已删除（0未删除，1已删除）的setter方法 */
  public void setDeleted(Integer deleted) {
    this.deleted = deleted;
  }
  /** 备注1的getter方法 */
  public String getByx1() {
    return byx1;
  }
  /** 备注1的setter方法 */
  public void setByx1(String byx1) {
    this.byx1 = byx1;
  }
  /** 备注2的getter方法 */
  public String getByx2() {
    return byx2;
  }
  /** 备注2的setter方法 */
  public void setByx2(String byx2) {
    this.byx2 = byx2;
  }
  /** 备注3的getter方法 */
  public String getByx3() {
    return byx3;
  }
  /** 备注3的setter方法 */
  public void setByx3(String byx3) {
    this.byx3 = byx3;
  }

  public String getStationId() {
    return stationId;
  }

  public void setStationId(String stationId) {
    this.stationId = stationId;
  }

  public Integer getType() {
    return type;
  }

  public void setType(Integer type) {
    this.type = type;
  }

  public String getPlanId() {
    return planId;
  }

  public void setPlanId(String planId) {
    this.planId = planId;
  }

  public LinkAttachment getFj() {
    return fj;
  }

  public void setFj(LinkAttachment fj) {
    this.fj = fj;
  }

  public String getEventTypeName() {
    return eventTypeName;
  }

  public void setEventTypeName(String eventTypeName) {
    this.eventTypeName = eventTypeName;
  }
}
