package com.devplatform.equipment.modules.alarms.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Date;

/**
 * @author Administrator
 */
@ApiModel(value = "报警处理(应急预案)步骤信息对象", description = "报警处理(应急预案)步骤信息对象")
@TableName("alarms_plan_step")
public class AlarmsPlanStep implements Serializable {
  /** */
  private static final long serialVersionUID = 1L;

  @ApiModelProperty(value = "主键ID", name = "id")
  @TableId
	/** 主键*/
  private String id; 

  @ApiModelProperty(value = "报警信息id", name = "alarmsId")
	/** 报警信息id*/
  private String alarmsId; 

  @ApiModelProperty(value = "预案登记id", name = "planId")
	/** 预案登记id*/
  private String planId; 

  @ApiModelProperty(value = "预案流程id", name = "stepId")
	/** 预案流程id*/
  private String stepId; 

  @ApiModelProperty(value = "预案流程指令id", name = "instructId")
	/** 预案流程指令id*/
  private String instructId; 

  @ApiModelProperty(value = "子系统code", name = "systemCode")
	/** 子系统code*/
  private String systemCode; 

  @ApiModelProperty(value = "资源点id", name = "resourceId")
	/** 资源点id*/
  private String resourceId; 

  @ApiModelProperty(value = "动作id", name = "actionId")
  private String actionId;

  @ApiModelProperty(value = "动作名称", name = "actionName")
  private String actionName;

  @ApiModelProperty(value = "运行方式1：人工响应 2：系统响应", name = "runMode")
	/** 运行方式1：人工响应 2：系统响应*/
  private Integer runMode; 

  @ApiModelProperty(value = "1:未执行 2：已执行", name = "status")
	/** 1:未执行 2：已执行*/
  private Integer status; 

  @ApiModelProperty(value = "是否已删除（0未删除，1已删除）", name = "deleted")
	/** 是否已删除（0未删除，1已删除）*/
  private Integer deleted; 

  @ApiModelProperty(value = "创建时间", name = "createTime")
	/** 创建时间*/
  private Date createTime; 

  @ApiModelProperty(value = "创建人id", name = "createUserId")
	/** 创建人id*/
  private String createUserId; 

  @ApiModelProperty(value = "修改时间(执行开始时间)", name = "updateTime")
	/** 修改时间(执行开始时间)*/
  private Date updateTime; 

  @ApiModelProperty(value = "执行完成时间", name = "endTime")
	/** 执行完成时间*/
  private Date endTime; 

  @ApiModelProperty(value = "执行人", name = "updateUserId")
	/** 执行人*/
  private String updateUserId; 

  @ApiModelProperty(value = "指令执行日志id(or开头的表)", name = "orId")
	/** 指令执行日志id(or开头的表)*/
  private String orId; 

  @ApiModelProperty(value = "排序", name = "sort")
  private Integer sort;

  @ApiModelProperty(value = "备用1", name = "byx1")
	/** 备用1*/
  private String byx1; 

  @ApiModelProperty(value = "备用2", name = "byx2")
	/** 备用2*/
  private String byx2; 

  @ApiModelProperty(value = "备用3", name = "byx3")
	/** 备用3*/
  private String byx3; 

  @ApiModelProperty(value = "系统标识", name = "sysSign")
  private String sysSign;

  @TableField(exist = false)
  private String content;

  @TableField(exist = false)
  private String resName;

  @TableField(exist = false)
  private String exeName;

  public String getSysSign() {
    return sysSign;
  }

  public void setSysSign(String sysSign) {
    this.sysSign = sysSign;
  }

  /** 主键的getter方法 */
  public String getId() {
    return id;
  }
  /** 主键的setter方法 */
  public void setId(String id) {
    this.id = id;
  }
  /** 报警信息id的getter方法 */
  public String getAlarmsId() {
    return alarmsId;
  }
  /** 报警信息id的setter方法 */
  public void setAlarmsId(String alarmsId) {
    this.alarmsId = alarmsId;
  }
  /** 预案登记id的getter方法 */
  public String getPlanId() {
    return planId;
  }
  /** 预案登记id的setter方法 */
  public void setPlanId(String planId) {
    this.planId = planId;
  }
  /** 预案流程id的getter方法 */
  public String getStepId() {
    return stepId;
  }
  /** 预案流程id的setter方法 */
  public void setStepId(String stepId) {
    this.stepId = stepId;
  }
  /** 预案流程指令id的getter方法 */
  public String getInstructId() {
    return instructId;
  }
  /** 预案流程指令id的setter方法 */
  public void setInstructId(String instructId) {
    this.instructId = instructId;
  }
  /** 运行方式1：人工响应 2：系统响应的getter方法 */
  public Integer getRunMode() {
    return runMode;
  }
  /** 运行方式1：人工响应 2：系统响应的setter方法 */
  public void setRunMode(Integer runMode) {
    this.runMode = runMode;
  }
  /** 1:未执行 2：已执行的getter方法 */
  public Integer getStatus() {
    return status;
  }
  /** 1:未执行 2：已执行的setter方法 */
  public void setStatus(Integer status) {
    this.status = status;
  }
  /** 是否已删除（0未删除，1已删除）的getter方法 */
  public Integer getDeleted() {
    return deleted;
  }
  /** 是否已删除（0未删除，1已删除）的setter方法 */
  public void setDeleted(Integer deleted) {
    this.deleted = deleted;
  }
  /** 创建时间的getter方法 */
  public Date getCreateTime() {
    return createTime;
  }
  /** 创建时间的setter方法 */
  public void setCreateTime(Date createTime) {
    this.createTime = createTime;
  }
  /** 创建人id的getter方法 */
  public String getCreateUserId() {
    return createUserId;
  }
  /** 创建人id的setter方法 */
  public void setCreateUserId(String createUserId) {
    this.createUserId = createUserId;
  }
  /** 修改时间(人工响应的执行时间)的getter方法 */
  public Date getUpdateTime() {
    return updateTime;
  }
  /** 修改时间(人工响应的执行时间)的setter方法 */
  public void setUpdateTime(Date updateTime) {
    this.updateTime = updateTime;
  }
  /** 执行人id的getter方法 */
  public String getUpdateUserId() {
    return updateUserId;
  }
  /** 执行人id的setter方法 */
  public void setUpdateUserId(String updateUserId) {
    this.updateUserId = updateUserId;
  }
  /** 指令执行日志id(or开头的表)的getter方法 */
  public String getOrId() {
    return orId;
  }
  /** 指令执行日志id(or开头的表)的setter方法 */
  public void setOrId(String orId) {
    this.orId = orId;
  }
  /** 备用1的getter方法 */
  public String getByx1() {
    return byx1;
  }
  /** 备用1的setter方法 */
  public void setByx1(String byx1) {
    this.byx1 = byx1;
  }
  /** 备用2的getter方法 */
  public String getByx2() {
    return byx2;
  }
  /** 备用2的setter方法 */
  public void setByx2(String byx2) {
    this.byx2 = byx2;
  }
  /** 备用3的getter方法 */
  public String getByx3() {
    return byx3;
  }
  /** 备用3的setter方法 */
  public void setByx3(String byx3) {
    this.byx3 = byx3;
  }

  public String getSystemCode() {
    return systemCode;
  }

  public void setSystemCode(String systemCode) {
    this.systemCode = systemCode;
  }

  public Date getEndTime() {
    return endTime;
  }

  public void setEndTime(Date endTime) {
    this.endTime = endTime;
  }

  public Integer getSort() {
    return sort;
  }

  public void setSort(Integer sort) {
    this.sort = sort;
  }

  public String getResourceId() {
    return resourceId;
  }

  public void setResourceId(String resourceId) {
    this.resourceId = resourceId;
  }

  public String getContent() {
    return content;
  }

  public void setContent(String content) {
    this.content = content;
  }

  public String getResName() {
    return resName;
  }

  public void setResName(String resName) {
    this.resName = resName;
  }

  public String getExeName() {
    return exeName;
  }

  public void setExeName(String exeName) {
    this.exeName = exeName;
  }

  public String getActionName() {
    return actionName;
  }

  public void setActionName(String actionName) {
    this.actionName = actionName;
  }

  public String getActionId() {
    return actionId;
  }

  public void setActionId(String actionId) {
    this.actionId = actionId;
  }
}
