package com.devplatform.equipment.modules.alarms.controller;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.devplatform.common.base.annotation.SysLog;
import com.devplatform.common.base.validator.ValidatorUtils;
import com.devplatform.common.util.R;
import com.devplatform.common.util.StringUtil;
import com.devplatform.equipment.common.annotation.SysLogMethod;
import com.devplatform.equipment.common.utils.AbstractController;
import com.devplatform.equipment.common.utils.DateUtil;
import com.devplatform.equipment.feign.service.AdminService;
import com.devplatform.equipment.modules.alarms.bean.AlarmsInfo;
import com.devplatform.equipment.modules.alarms.model.AlarmsInfoModel;
import com.devplatform.equipment.modules.alarms.service.AlarmsInfoService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author Administrator
 */
@Api(tags = {"报警信息接口"})
@RestController
@RequestMapping("/alarmsInfo")
public class AlarmsInfoController extends AbstractController {

  @Autowired private AlarmsInfoService alarmsInfoService;

  @Autowired(required = false)
  private AdminService adminService;

  /**
   * 列表页面列表数据获取
   *
   * @param model 承接对象
   * @return
   */
  @ApiOperation(value = "根据条件获取报警信息分页数据列表", notes = "根据条件获取报警信息分页数据列表")
  @ApiImplicitParam(
      name = "params",
      value = "参数",
      required = true,
      dataType = "Map<String, Object>")
  @PostMapping("/list")
  public R list(@RequestBody AlarmsInfoModel model) {
    if (StringUtils.isBlank(model.getSort())) {
      model.setSort("occurrence_time");
      model.setOrder("DESC");
    }
    return R.ok().put("page", getMyPage(alarmsInfoService.queryPageByList(model), model));
  }

  /**
   * 获取报警数据
   *
   * @param params 承接对象
   * @return
   */
  @ApiOperation(value = "根据条件获取报警信息数据", notes = "根据条件获取报警信息数据")
  @ApiImplicitParam(
      name = "params",
      value = "参数",
      required = true,
      dataType = "Map<String, Object>")
  @PostMapping("/queryList")
  public R queryList(@RequestParam Map<String, Object> params) {
    List<AlarmsInfo> list = alarmsInfoService.queryAll(params);
    return R.ok().put("list", list);
  }

  @ApiOperation(value = "统计报警未处理信息", notes = "统计报警未处理信息")
  @GetMapping("/queryGroupUntreated")
  public R queryGroupUntreated() {
    List<AlarmsInfo> list = alarmsInfoService.queryGroupUntreated();
    return R.ok().put("list", list);
  }

  @ApiOperation(value = "统计报警已处理信息", notes = "统计报警已处理信息")
  @GetMapping("/queryGroupProcessed")
  public R queryGroupProcessed() {
    List<AlarmsInfo> list = alarmsInfoService.queryGroupProcessed();
    return R.ok().put("list", list);
  }

  /**
   * 视频回放，根据条件获取报警数据和带有视频附件的信息
   *
   * @param params 承接对象
   * @return
   */
  @ApiOperation(value = "根据条件获取报警信息数据", notes = "根据条件获取报警信息数据")
  @ApiImplicitParam(
      name = "params",
      value = "参数",
      required = true,
      dataType = "Map<String, Object>")
  @PostMapping("/queryByCameraList")
  public R queryByCameraList(@RequestParam Map<String, Object> params) {
    List<Map<String, Object>> list = alarmsInfoService.queryByCameraList(params);
    return R.ok().put("list", list);
  }

  /**
   * 视频回放，根据条件获取报警数据视频附件的信息
   *
   * @param alarmsId
   * @return
   */
  @ApiOperation(value = "根据条件获取报警信息数据", notes = "根据条件获取报警信息数据")
  @ApiImplicitParam(
      name = "params",
      value = "参数",
      required = true,
      dataType = "Map<String, Object>")
  @PostMapping("/queryByCameraVideoList")
  public R queryByCameraVideoList(String alarmsId, String stationId) {
    List<Map<String, Object>> list = alarmsInfoService.queryByCameraVideoList(alarmsId, stationId);
    return R.ok().put("list", list);
  }

  /**
   * 添加
   *
   * @param bean 报警信息对象
   * @return
   */
  @SysLog("添加报警信息")
  @SysLogMethod(operation = "新增", blockName = "报警信息", detail = "新增报警信息数据")
  @ApiOperation(value = "新增报警信息数据", notes = "新增报警信息数据")
  @PostMapping("/save")
  public R save(@RequestBody @ApiParam(value = "报警信息实体对象", required = true) AlarmsInfo bean) {
    ValidatorUtils.validateEntity(bean);
    bean.setCreateUserId(getUserId());
    bean.setCreateTime(new Date());
    alarmsInfoService.save(bean);
    return R.ok();
  }

  /**
   * 修改
   *
   * @param bean 报警信息对象
   * @return
   */
  @SysLog("修改报警信息")
  @SysLogMethod(operation = "修改", blockName = "报警信息", detail = "修改报警信息数据")
  @ApiOperation(value = "修改报警信息数据", notes = "修改报警信息数据")
  @PostMapping("/update")
  public R update(@RequestBody @ApiParam(value = "报警信息实体对象", required = true) AlarmsInfo bean) {
    Boolean beSend = bean.getBeSend();
    ValidatorUtils.validateEntity(bean);
    bean.setUpdateUserId(getUserId());
    bean.setUpdateTime(new Date());
    bean.setSysSign(getUser().getSysSystem().getCode());
    alarmsInfoService.update(
        bean,
        new QueryWrapper<AlarmsInfo>()
            .eq(StringUtil.checkNotNull(bean.getId()), "id", bean.getId())
            .eq(StringUtil.checkNotNull(bean.getStationId()), "station_id", bean.getStationId()));

    if (beSend) {
      // 如果为true则需要发送给websocket
      AlarmsInfo ai = alarmsInfoService.queryById(bean.getId(), bean.getStationId());
      Map<String, Object> map = new HashMap<>(10);
      map.put("id", ai.getId());
      map.put("eventName", ai.getEventName());
      map.put("eventLevel", ai.getEventLevel());
      map.put("occurrenceSite", ai.getOccurrenceSite());
      map.put("occurrenceTime", DateUtil.getPlusTime(ai.getOccurrenceTime()));
      map.put("resourceName", ai.getResourceName());
      map.put("status", ai.getStatus());
      map.put("fj", ai.getFj());
      adminService.sendAlramsInfo(map);
    }
    return R.ok();
  }

  /**
   * 根据ID获取报警信息对象
   *
   * @param id 对象主键
   * @return
   */
  @ApiOperation(value = "根据ID获取报警信息对象", notes = "根据ID获取报警信息对象")
  @ApiImplicitParam(name = "id", value = "主键", required = true, dataType = "String")
  @GetMapping("/getId")
  public R getId(String id, String stationId) {
    AlarmsInfo bean = alarmsInfoService.queryById(id, stationId);
    return R.ok().put("bean", bean);
  }

  /**
   * 根据ID获取报警信息对象
   *
   * @param ids 报警信息对象主键数组
   * @return
   */
  @SysLog("删除报警信息")
  @SysLogMethod(operation = "删除", blockName = "报警信息", detail = "删除报警信息数据")
  @ApiOperation(value = "根据ID批量删除报警信息数据", notes = "根据ID批量删除报警信息数据")
  @ApiImplicitParam(name = "ids", value = "主键数组", required = true, dataType = "String")
  @PostMapping("/delete")
  public R delete(@RequestBody String[] ids) {
    alarmsInfoService.removeByIds(Arrays.asList(ids));
    return R.ok();
  }
}
