package com.devplatform.equipment.modules.alarms.controller;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.devplatform.common.base.annotation.SysLog;
import com.devplatform.common.base.validator.ValidatorUtils;
import com.devplatform.common.util.PageUtils;
import com.devplatform.common.util.R;
import com.devplatform.common.util.StringUtil;
import com.devplatform.equipment.common.annotation.SysLogMethod;
import com.devplatform.equipment.common.utils.AbstractController;
import com.devplatform.equipment.modules.alarms.bean.AlarmsOpinion;
import com.devplatform.equipment.modules.alarms.service.AlarmsOpinionService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author Administrator
 */
@Api(tags = {"报警意见处理信息接口"})
@RestController
@RequestMapping("/alarmsOpinion")
public class AlarmsOpinionController extends AbstractController {

  @Autowired private AlarmsOpinionService alarmsOpinionService;

  /**
   * 列表页面列表数据获取
   *
   * @param model 承接对象
   * @return
   */
  @ApiOperation(value = "根据条件获取报警意见处理信息分页数据列表", notes = "根据条件获取报警意见处理信息分页数据列表")
  @ApiImplicitParam(
      name = "params",
      value = "参数",
      required = true,
      dataType = "Map<String, Object>")
  @PostMapping("/list")
  public R list(@RequestParam Map<String, Object> params) {
    PageUtils page = alarmsOpinionService.queryPage(params, null);
    return R.ok().put("page", page);
  }

  /**
   * 添加
   *
   * @param bean 报警意见处理信息对象
   * @return
   */
  @SysLog("添加报警意见处理信息")
  @SysLogMethod(operation = "新增", blockName = "报警意见处理信息", detail = "新增报警意见处理信息数据")
  @ApiOperation(value = "新增报警意见处理信息数据", notes = "新增报警意见处理信息数据")
  @PostMapping("/save")
  public R save(
      @RequestBody @ApiParam(value = "报警意见处理信息实体对象", required = true) AlarmsOpinion bean) {
    ValidatorUtils.validateEntity(bean);
    bean.setCreateUserId(getUserId());
    bean.setCreateTime(new Date());
    alarmsOpinionService.save(bean);
    return R.ok();
  }

  /**
   * 修改
   *
   * @param bean 报警意见处理信息对象
   * @return
   */
  @SysLog("修改报警意见处理信息")
  @SysLogMethod(operation = "修改", blockName = "报警意见处理信息", detail = "修改报警意见处理信息数据")
  @ApiOperation(value = "修改报警意见处理信息数据", notes = "修改报警意见处理信息数据")
  @PostMapping("/update")
  public R update(
      @RequestBody @ApiParam(value = "报警意见处理信息实体对象", required = true) AlarmsOpinion bean) {
    ValidatorUtils.validateEntity(bean);
    bean.setSysSign(getUser().getSysSystem().getCode());
    alarmsOpinionService.update(
        bean,
        new QueryWrapper<AlarmsOpinion>()
            .eq(StringUtil.checkNotNull(bean.getId()), "id", bean.getId()));
    return R.ok();
  }

  /**
   * 根据ID获取报警意见处理信息对象
   *
   * @param id 对象主键
   * @return
   */
  @ApiOperation(value = "根据ID获取报警意见处理信息对象", notes = "根据ID获取报警意见处理信息对象")
  @ApiImplicitParam(name = "id", value = "主键", required = true, dataType = "String")
  @GetMapping("/getId/{id}")
  public R getId(@PathVariable String id) {
    AlarmsOpinion bean = alarmsOpinionService.getById(id);
    return R.ok().put("bean", bean);
  }

  /**
   * 根据ID获取报警意见处理信息对象
   *
   * @param id[] 报警意见处理信息对象主键数组
   * @return
   */
  @SysLog("删除报警意见处理信息")
  @SysLogMethod(operation = "删除", blockName = "报警意见处理信息", detail = "删除报警意见处理信息数据")
  @ApiOperation(value = "根据ID批量删除报警意见处理信息数据", notes = "根据ID批量删除报警意见处理信息数据")
  @ApiImplicitParam(name = "ids", value = "主键数组", required = true, dataType = "String")
  @PostMapping("/delete")
  public R delete(@RequestBody String[] ids) {
    alarmsOpinionService.removeByIds(Arrays.asList(ids));
    return R.ok();
  }

  /**
   * 根据ID获取报警意见处理信息对象
   *
   * @param id 对象主键
   * @return
   */
  @ApiOperation(value = "根据ID获取报警意见处理信息对象", notes = "根据ID获取报警意见处理信息对象")
  @ApiImplicitParam(name = "alarmsId", value = "主键", required = true, dataType = "String")
  @GetMapping("/getAlarmsId/{alarmsId}")
  public R getAlarmsId(@PathVariable String alarmsId) {
    List<AlarmsOpinion> list = alarmsOpinionService.getAlarmsId(alarmsId);
    return R.ok().put("list", list);
  }
}
