package com.devplatform.equipment.modules.alarms.controller;

import com.devplatform.common.base.annotation.SysLog;
import com.devplatform.common.base.validator.ValidatorUtils;
import com.devplatform.common.util.PageUtils;
import com.devplatform.common.util.R;
import com.devplatform.equipment.common.annotation.SysLogMethod;
import com.devplatform.equipment.common.utils.AbstractController;
import com.devplatform.equipment.modules.alarms.bean.AlarmsPlanStep;
import com.devplatform.equipment.modules.alarms.service.AlarmsInfoService;
import com.devplatform.equipment.modules.alarms.service.AlarmsPlanStepService;
import com.devplatform.equipment.modules.orgate.service.OrGateService;
import com.devplatform.equipment.modules.orintrude.service.OrIntrudeService;
import com.devplatform.equipment.modules.orsafetycheck.service.OrSafetyCheckService;
import com.devplatform.equipment.modules.orvideomonitor.service.OrVideoMonitorService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import lombok.SneakyThrows;
import org.apache.commons.beanutils.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author Administrator
 */
@Api(tags = {"报警处理(应急预案)步骤信息接口"})
@RestController
@RequestMapping("/alarmsPlanStep")
public class AlarmsPlanStepController extends AbstractController {

  @Autowired private AlarmsPlanStepService alarmsPlanStepService;
  @Autowired private AlarmsInfoService alarmsInfoService;
  @Autowired private OrVideoMonitorService orVideoMonitorService;
  @Autowired private OrGateService orGateService;
  @Autowired private OrIntrudeService orIntrudeService;
  @Autowired private OrSafetyCheckService orSafetyCheckService;

  @SneakyThrows
  @SuppressWarnings("all") // 消除警告
  private static <T> T mapToBean(Map<String, Object> map, Class<T> clazz)
      throws NoSuchMethodException, SecurityException, InstantiationException,
          IllegalAccessException, IllegalArgumentException, InvocationTargetException {
    Constructor<T> constructor = clazz.getDeclaredConstructor();
    constructor.setAccessible(true);
    T bean = constructor.newInstance();
    BeanUtils.populate(bean, map);
    return bean;
  }

  /**
   * 列表页面列表数据获取
   *
   * @param params 承接对象
   * @return
   */
  @ApiOperation(value = "根据条件获取报警处理(应急预案)步骤信息分页数据列表", notes = "根据条件获取报警处理(应急预案)步骤信息分页数据列表")
  @ApiImplicitParam(
      name = "params",
      value = "参数",
      required = true,
      dataType = "Map<String, Object>")
  @PostMapping("/list")
  public R list(@RequestParam Map<String, Object> params) {
    PageUtils page = alarmsPlanStepService.queryPage(params, null);
    return R.ok().put("page", page);
  }

  /**
   * 添加
   *
   * @param bean 报警处理(应急预案)步骤信息对象
   * @return
   */
  @SysLog("添加报警处理(应急预案)步骤信息")
  @SysLogMethod(operation = "新增", blockName = "报警处理(应急预案)步骤信息", detail = "新增报警处理(应急预案)步骤信息数据")
  @ApiOperation(value = "新增报警处理(应急预案)步骤信息数据", notes = "新增报警处理(应急预案)步骤信息数据")
  @PostMapping("/save")
  public R save(
      @RequestBody @ApiParam(value = "报警处理(应急预案)步骤信息实体对象", required = true) AlarmsPlanStep bean) {
    ValidatorUtils.validateEntity(bean);
    bean.setCreateUserId(getUserId());
    bean.setCreateTime(new Date());
    alarmsPlanStepService.save(bean);
    return R.ok();
  }

  /**
   * 根据ID获取报警处理(应急预案)步骤信息对象
   *
   * @param id 对象主键
   * @return
   */
  @ApiOperation(value = "根据ID获取报警处理(应急预案)步骤信息对象", notes = "根据ID获取报警处理(应急预案)步骤信息对象")
  @ApiImplicitParam(name = "id", value = "主键", required = true, dataType = "String")
  @GetMapping("/getId/{id}")
  public R getId(@PathVariable String id) {
    AlarmsPlanStep bean = alarmsPlanStepService.getById(id);
    return R.ok().put("bean", bean);
  }

  /**
   * 根据ID获取报警处理(应急预案)步骤信息对象
   *
   * @param ids 报警处理(应急预案)步骤信息对象主键数组
   * @return
   */
  @SysLog("删除报警处理(应急预案)步骤信息")
  @SysLogMethod(operation = "删除", blockName = "报警处理(应急预案)步骤信息", detail = "删除报警处理(应急预案)步骤信息数据")
  @ApiOperation(value = "根据ID批量删除报警处理(应急预案)步骤信息数据", notes = "根据ID批量删除报警处理(应急预案)步骤信息数据")
  @ApiImplicitParam(name = "ids", value = "主键数组", required = true, dataType = "String")
  @PostMapping("/delete")
  public R delete(@RequestBody String[] ids) {
    alarmsPlanStepService.removeByIds(Arrays.asList(ids));
    return R.ok();
  }

  /**
   * 根据alarmsId获取报警处理应急预案步骤信息
   *
   * @return
   */
  @ApiOperation(value = "根据alarmsId获取报警处理应急预案步骤信息", notes = "根据alarmsId获取报警处理应急预案步骤信息")
  @ApiImplicitParam(name = "alarmsId", value = "主键", required = true, dataType = "String")
  @GetMapping("/getPlanStepList/{alarmsId}")
  public R getPlanStepList(@PathVariable("alarmsId") String alarmsId) {
    List<AlarmsPlanStep> list = alarmsPlanStepService.getPlanStepList(alarmsId);
    return R.ok().put("list", list);
  }
}
