package com.devplatform.equipment.modules.alarms.dao;

import com.devplatform.common.dao.MyBaseMapper;
import com.devplatform.equipment.modules.alarms.bean.AlarmsInfo;
import com.devplatform.equipment.modules.alarms.model.AlarmsInfoModel;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

/**
 * AlarmsInfo Mapper 用于报警信息的数据库操作
 *
 * @author Administrator
 */
@Mapper
@Repository
public interface AlarmsInfoDao extends MyBaseMapper<AlarmsInfo> {

  /**
   * 根据id查询报警信息
   * @param id
   * @param stationId
   * @return
   */
  AlarmsInfo queryById(String id, String stationId);

  /**
   * 查询报警数量
   * @param model
   * @return
   */
  Integer queryPageByCount(AlarmsInfoModel model);

  /**
   * 查询报警数据
   * @param model
   * @return
   */
  List<AlarmsInfo> queryPageByList(AlarmsInfoModel model);

  /**
   * 查询所有满足条件的报警信息
   * @param params
   * @return
   */
  List<AlarmsInfo> queryAll(@Param("params") Map<String, Object> params);

  /**
   * 查询未处理报警
   * @return
   */
  List<AlarmsInfo> queryGroupUntreated();

  /**
   * 查询已处理报警
   * @return
   */
  List<AlarmsInfo> queryGroupProcessed();

  /**
   * 查询数量
   * @param params
   * @return
   */
  Integer countNum(@Param("params") Map<String, Object> params);

  /**
   * 查询报警的历史视频
   * @param id
   * @param stationId
   * @return
   */
  List<HashMap<String, Object>> getHistoryVideInfo(@Param("id") String id, @Param("stationId") String stationId);

  /**
   * 查询摄像头
   * @param params
   * @return
   */
  List<Map<String, Object>> queryByCameraList(@Param("params") Map<String, Object> params);

  /**
   * 查询摄像头的视频信息
   * @param alarmsId
   * @param stationId
   * @return
   */
  List<Map<String, Object>> queryByCameraVideoList(@Param("alarmsId") String alarmsId, @Param("stationId") String stationId);

  /**
   * 计算数量
   * @param params
   * @return
   */
  Integer cNum(@Param("params") Map<String, Object> params);

  /**
   * 查询报警信息
   * @param model
   * @return
   */
  AlarmsInfo queryBsZt(AlarmsInfoModel model);
}
