package com.devplatform.equipment.modules.alarms.dao;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.devplatform.common.dao.MyBaseMapper;
import com.devplatform.equipment.modules.alarms.bean.AlarmsLog;
import java.util.HashMap;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

/**
 * AlarmsLog Mapper 用于报警日志表的数据库操作
 *
 * @author Administrator
 */
@Mapper
@Repository
public interface AlarmsLogDao extends MyBaseMapper<AlarmsLog> {

  /**
   * 查询报警日志信息
   * @param page
   * @param par
   * @param startTime
   * @param endTime
   * @param sort
   * @param order
   * @return
   */
  IPage<HashMap<String, Object>> instructList(
      @Param("page") Page<HashMap<String, Object>> page,
      @Param("par") String par,
      @Param("startTime") String startTime,
      @Param("endTime") String endTime,
      @Param("sort") String sort,
      @Param("order") String order);
}
