package com.devplatform.equipment.modules.alarms.dao;

import com.devplatform.common.dao.MyBaseMapper;
import com.devplatform.equipment.modules.alarms.bean.AlarmsPlanStep;
import java.util.HashMap;
import java.util.List;
import org.apache.ibatis.annotations.Mapper;
import org.springframework.stereotype.Repository;

/**
 * AlarmsPlanStep Mapper 用于报警处理(应急预案)步骤信息的数据库操作
 *
 * @author Administrator
 */
@Mapper
@Repository
public interface AlarmsPlanStepDao extends MyBaseMapper<AlarmsPlanStep> {

  /**
   * 查询报警预案步骤
   * @param alarmsId
   * @return
   */
  List<AlarmsPlanStep> getPlanStepList(String alarmsId);

  /**
   * 查询报警预案步骤
   * @param alarmsId
   * @return
   */
  List<HashMap<String, Object>> getPlanStepList1(String alarmsId);
}
