package com.devplatform.equipment.modules.alarms.service;

import com.devplatform.common.service.MyBaseService;
import com.devplatform.equipment.modules.alarms.bean.AlarmsInfo;
import com.devplatform.equipment.modules.alarms.model.AlarmsInfoModel;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 报警信息的service接口 <br>
 * <b>功能：</b>AlarmsInfoService<br>
 *
 * @author 代码生成器产生
 */
public interface AlarmsInfoService extends MyBaseService<AlarmsInfo> {

  /**
   * 根据id查询报警信息
   * @param id
   * @param stationId
   * @return
   */
  AlarmsInfo queryById(String id, String stationId);

  /**
   * 分页查询
   *
   * @param model
   * @return
   */
  List<AlarmsInfo> queryPageByList(AlarmsInfoModel model);
  /**
   * 未处理
   *
   * @return
   */
  List<AlarmsInfo> queryGroupUntreated();

  /**
   * 已处理
   *
   * @return
   */
  List<AlarmsInfo> queryGroupProcessed();

  /**
   * 根据状态和站点id查询
   *
   * @param params
   * @return
   */
  List<AlarmsInfo> queryAll(Map<String, Object> params);

  /**
   * 计算数量
   * @param params
   * @return
   */
  Integer countNum(Map<String, Object> params);

  /**
   * 根据报警id查询历史报警视频
   * @param id
   * @param stationId
   * @return
   */
  List<HashMap<String, Object>> getHistoryVideInfo(String id, String stationId);

  /**
   * 查询摄像头信息
   * @param params
   * @return
   */
  List<Map<String, Object>> queryByCameraList(Map<String, Object> params);

  /**
   * 查询摄像头视频信息
   * @param alarmsId
   * @param stationId
   * @return
   */
  List<Map<String, Object>> queryByCameraVideoList(String alarmsId, String stationId);

  /**
   * 计算数量
   * @param params
   * @return
   */
  Integer cNum(Map<String, Object> params);

  /**
   * 查询报警信息
   * @param model
   * @return
   */
  AlarmsInfo queryBsZt(AlarmsInfoModel model);
}
