package com.devplatform.equipment.modules.alarms.service.impl;

import com.devplatform.common.service.impl.MyBaseServiceImpl;
import com.devplatform.equipment.modules.alarms.bean.AlarmsInfo;
import com.devplatform.equipment.modules.alarms.dao.AlarmsInfoDao;
import com.devplatform.equipment.modules.alarms.model.AlarmsInfoModel;
import com.devplatform.equipment.modules.alarms.service.AlarmsInfoService;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Service;

/**
 * 报警信息的service接口实现类 <br>
 * <b>功能：</b>AlarmsInfoServiceImpl<br>
 *
 * @author 代码生成器产生
 */
@Service("alarmsInfoService")
public class AlarmsInfoServiceImpl extends MyBaseServiceImpl<AlarmsInfoDao, AlarmsInfo>
    implements AlarmsInfoService {

  @Override
  public AlarmsInfo queryById(String id, String stationId) {
    return baseMapper.queryById(id, stationId);
  }

  @Override
  public List<AlarmsInfo> queryPageByList(AlarmsInfoModel model) {
    Integer rowCount = baseMapper.queryPageByCount(model);
    model.getPager().setRowCount(rowCount);
    return baseMapper.queryPageByList(model);
  }

  @Override
  public List<AlarmsInfo> queryGroupUntreated() {
    return baseMapper.queryGroupUntreated();
  }

  @Override
  public List<AlarmsInfo> queryGroupProcessed() {
    return baseMapper.queryGroupProcessed();
  }

  @Override
  public List<AlarmsInfo> queryAll(Map<String, Object> params) {
    return baseMapper.queryAll(params);
  }

  @Override
  public Integer countNum(Map<String, Object> params) {
    return baseMapper.countNum(params);
  }

  @Override
  public List<HashMap<String, Object>> getHistoryVideInfo(String id, String stationId) {
    return baseMapper.getHistoryVideInfo(id, stationId);
  }

  @Override
  public List<Map<String, Object>> queryByCameraList(Map<String, Object> params) {
    return baseMapper.queryByCameraList(params);
  }

  @Override
  public List<Map<String, Object>> queryByCameraVideoList(String alarmsId, String stationId) {
    return baseMapper.queryByCameraVideoList(alarmsId, stationId);
  }

  @Override
  public Integer cNum(Map<String, Object> params) {
    return baseMapper.cNum(params);
  }

  @Override
  public AlarmsInfo queryBsZt(AlarmsInfoModel model) {
    return baseMapper.queryBsZt(model);
  }
}
