package com.devplatform.equipment.modules.eppatrolline.dao;

import com.devplatform.common.dao.MyBaseMapper;
import com.devplatform.equipment.modules.eppatrolline.bean.EpPatrolLine;
import java.util.List;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

/**
 * EpPatrolLine Mapper 用于电子巡查线路表管理的数据库操作
 *
 * @author Administrator
 */
@Mapper
@Repository
public interface EpPatrolLineDao extends MyBaseMapper<EpPatrolLine> {

  /**
   * 删除线路
   * @param id
   * @param stationId
   * @param sysSign
   */
  void deleteByLineId(
      @Param("id") String id,
      @Param("stationId") String stationId,
      @Param("sysSign") String sysSign);

  /**
   * 查询线路
   * @param id
   * @return
   */
  List<EpPatrolLine> getTreeListByStationId(String id);
}
