package com.devplatform.equipment.modules.eppatrolline.service;

import com.devplatform.common.service.MyBaseService;
import com.devplatform.equipment.modules.eppatrolline.bean.EpPatrolLine;
import com.devplatform.equipment.modules.eppatrolline.model.EpPatrolLineModel;
import java.util.List;

/**
 * 电子巡查线路表管理的service接口 <br>
 * <b>功能：</b>EpPatrolLineService<br>
 *
 * @author 代码生成器产生
 */
public interface EpPatrolLineService extends MyBaseService<EpPatrolLine> {

  /**
   * 根据主键逻辑删除
   * @param id
   * @param stationId
   * @param sysSign
   */
  void deleteById(String id, String stationId, String sysSign);

  /**
   * 根据站点id查找全部巡查线路
   * @param id
   * @return
   */
  List<EpPatrolLine> getTreeListByStationId(String id);

  /**
   * 保存巡查路线下的巡查点信息
   * @param model
   * @param userId
   * @param sysSign
   */
  void savePoint(EpPatrolLineModel model, String userId, String sysSign);
}
