package com.devplatform.equipment.modules.eppatrolline.service.impl;

import com.devplatform.common.service.impl.MyBaseServiceImpl;
import com.devplatform.equipment.modules.eppatrolline.bean.EpPatrolLine;
import com.devplatform.equipment.modules.eppatrolline.dao.EpPatrolLineDao;
import com.devplatform.equipment.modules.eppatrolline.model.EpPatrolLineModel;
import com.devplatform.equipment.modules.eppatrolline.service.EpPatrolLineService;
import com.devplatform.equipment.modules.eppatrollinepoint.bean.EpPatrolLinePoint;
import com.devplatform.equipment.modules.eppatrollinepoint.service.EpPatrolLinePointService;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/**
 * 电子巡查线路表管理的service接口实现类 <br>
 * <b>功能：</b>EpPatrolLineServiceImpl<br>
 *
 * @author 代码生成器产生
 */
@Service("epPatrolLineService")
public class EpPatrolLineServiceImpl extends MyBaseServiceImpl<EpPatrolLineDao, EpPatrolLine>
    implements EpPatrolLineService {

  @Autowired private EpPatrolLinePointService epPatrolLinePointService;

  @Override
  @Transactional(rollbackFor = Exception.class)
  public void deleteById(String id, String stationId, String sysSign) {
	// 逻辑删除巡查线路
    baseMapper.deleteByLineId(id, stationId, sysSign);
	// 删除巡查路线下的所有巡查点
    epPatrolLinePointService.deleteByLineId(id, stationId, sysSign);
  }

  @Override
  public List<EpPatrolLine> getTreeListByStationId(String id) {
    return baseMapper.getTreeListByStationId(id);
  }

  @Override
  @Transactional(rollbackFor = Exception.class)
  public void savePoint(EpPatrolLineModel model, String userId, String sysSign) {
    ArrayList<EpPatrolLinePoint> epPatrolLinePointList = new ArrayList<>();
    int orderNum = 1;
    for (String pointId : model.getPointIds()) {
      EpPatrolLinePoint epPatrolLinePoint = new EpPatrolLinePoint();
      epPatrolLinePoint.setLineId(model.getId());
      epPatrolLinePoint.setLayerId(model.getTierId());
      epPatrolLinePoint.setPointId(pointId);
      epPatrolLinePoint.setOrderNum(orderNum);
      epPatrolLinePoint.setCreateUserId(userId);
      epPatrolLinePoint.setCreateTime(new Date());
      epPatrolLinePoint.setSysSign(sysSign);
      epPatrolLinePoint.setStationId(model.getStationId());
      epPatrolLinePointList.add(epPatrolLinePoint);
      orderNum++;
    }

    // 先根据线路删除原来的，再将新巡查点重新保存
    epPatrolLinePointService.deleteByLineId(model.getId(), model.getStationId(), sysSign);
    if (epPatrolLinePointList.size() > 0) {
      epPatrolLinePointService.saveBatch(epPatrolLinePointList);
    }
  }
}
