package com.devplatform.equipment.modules.eppatrollinepoint.dao;

import com.devplatform.common.dao.MyBaseMapper;
import com.devplatform.equipment.modules.eppatrollinepoint.bean.EpPatrolLinePoint;
import java.util.List;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

/**
 * EpPatrolLinePoint Mapper 用于电子巡查线路巡查点管理的数据库操作
 *
 * @author Administrator
 */
@Mapper
@Repository
public interface EpPatrolLinePointDao extends MyBaseMapper<EpPatrolLinePoint> {

  /**
   * 删除线路
   * @param lineId
   * @param stationId
   * @param sysSign
   */
  void deleteByLineId(
      @Param("lineId") String lineId,
      @Param("stationId") String stationId,
      @Param("sysSign") String sysSign);

  /**
   * 查询数量
   * @param id
   * @param stationId
   * @return
   */
  int countByPatrolId(String id, String stationId);

  /**
   * 查询数据
   * @param lineId
   * @param stationId
   * @return
   */
  List<EpPatrolLinePoint> getTreeListByLineId(
      @Param("lineId") String lineId, @Param("stationId") String stationId);

  /**
   * 查询数据
   * @param lineId
   * @param stationId
   * @param planId
   * @return
   */
  List<EpPatrolLinePoint> getResultByLineId(
      @Param("lineId") String lineId, @Param("stationId") String stationId,@Param("planId") String planId);
}
