package com.devplatform.equipment.modules.eppatrollinepoint.service;

import com.devplatform.common.service.MyBaseService;
import com.devplatform.equipment.modules.eppatrollinepoint.bean.EpPatrolLinePoint;
import java.util.List;

/**
 * 电子巡查线路巡查点管理的service接口 <br>
 * <b>功能：</b>EpPatrolLinePointService<br>
 *
 * @author 代码生成器产生
 */
public interface EpPatrolLinePointService extends MyBaseService<EpPatrolLinePoint> {

  /**
   * 根据巡查线路id删除电子巡查线路巡查点
   * @param id
   * @param stationId
   * @param sysSign
   */
  void deleteByLineId(String id, String stationId, String sysSign);

  /**
   * 根据巡查点Id统计被加入的电子巡查线路条数
   * @param id
   * @param stationId
   * @return
   */
  int countByPatrolId(String id, String stationId);

  /**
   * 根据巡查线路id获取电子巡查线路巡查点
   * @param id
   * @param stationId
   * @return
   */
  List<EpPatrolLinePoint> getTreeListByLineId(String id, String stationId);

  /**
   * 根据巡查线路id获取电子巡查线路巡查信息
   * @param id
   * @param stationId
   * @param planId
   * @return
   */
  List<EpPatrolLinePoint> getResultByLineId(String id, String stationId,String planId);
}
