package com.devplatform.equipment.modules.eppatrolmachine.dao;

import com.devplatform.common.dao.MyBaseMapper;
import com.devplatform.equipment.modules.eppatrolmachine.bean.EpPatrolMachine;
import com.devplatform.equipment.modules.eppatrolmachine.model.EpPatrolMachineModel;
import java.util.List;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

/**
 * EpPatrolMachine Mapper 用于电子巡查巡更机表的数据库操作
 *
 * @author Administrator
 */
@Mapper
@Repository
public interface EpPatrolMachineDao extends MyBaseMapper<EpPatrolMachine> {

  /**
   * 删除巡更机
   * @param id
   * @param stationId
   * @param sysSign
   */
  void removeById(@Param("id") String id, @Param("stationId") String stationId, @Param("sysSign") String sysSign);

  /**
   * 获取巡更机分页数据
   * @param model
   * @return
   */
  List<EpPatrolMachine> queryPageByList(EpPatrolMachineModel model);

  /**
   * 获取巡更机分页数量
   * @param model
   * @return
   */
  Integer queryPageByCount(EpPatrolMachineModel model);
}
