package com.devplatform.equipment.modules.eppatrolmissed.controller;

import com.devplatform.common.util.R;
import com.devplatform.common.util.StringUtil;
import com.devplatform.equipment.common.annotation.SysLogMethod;
import com.devplatform.equipment.common.utils.AbstractController;
import com.devplatform.equipment.common.utils.Constants;
import com.devplatform.equipment.common.utils.MyPage;
import com.devplatform.equipment.modules.eppatrolmissed.bean.EpPatrolMissed;
import com.devplatform.equipment.modules.eppatrolmissed.model.EpPatrolMissedModel;
import com.devplatform.equipment.modules.eppatrolmissed.service.EpPatrolMissedService;
import com.devplatform.equipment.modules.eppatrolplan.bean.EpPatrolPlan;
import com.devplatform.equipment.modules.eppatrolplan.service.EpPatrolPlanService;
import com.devplatform.equipment.modules.eppatrolpointresult.bean.EpPatrolPointResult;
import com.devplatform.equipment.modules.eppatrolpointresult.service.EpPatrolPointResultService;
import com.devplatform.equipment.modules.eppatrolresult.bean.EpPatrolResult;
import com.devplatform.equipment.modules.eppatrolresult.service.EpPatrolResultService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import sun.misc.BASE64Encoder;

/**
 * @author Administrator
 */
@Api(tags = {"电子巡查漏检数据表接口"})
@RestController
@RequestMapping("/epPatrolMissed")
public class EpPatrolMissedController extends AbstractController {

  @Autowired private EpPatrolMissedService epPatrolMissedService;

  @Autowired private EpPatrolPointResultService epPatrolPointResultService;

  @Autowired private EpPatrolResultService epPatrolResultService;

  @Autowired private EpPatrolPlanService epPatrolPlanService;
  /**
   * 列表页面列表数据获取
   *
   * @param model 承接对象 stationId 站点id keywords 可能是计划名称 线路名称 巡查员姓名 page 页码 rows 行数
   * @return
   */
  @ApiOperation(value = "根据条件获取电子巡查漏检数据表分页数据列表", notes = "根据条件获取电子巡查漏检数据表分页数据列表")
  @ApiImplicitParam(name = "model", value = "参数", required = true, dataType = "EpPatrolMissedModel")
  @PostMapping("/list")
  public R list(@RequestBody EpPatrolMissedModel model) {
    if (StringUtil.isEmpty(model.getSort())) {
      model.setSort("create_time");
      model.setOrder("DESC");
    }

    List<EpPatrolMissed> list = epPatrolMissedService.queryPageByList(model);
    return R.ok().put("page", getMyPage(list, model));
  }

  /**
   * 根据ID获取电子巡查漏检数据表对象
   *
   * @param id 对象主键
   * @return
   */
  @SysLogMethod(operation = "查看", blockName = "电子巡更", detail = "查看漏检数据详情")
  @ApiOperation(value = "根据ID获取电子巡查漏检数据表详情对象", notes = "根据ID获取电子巡查漏检数据表详情对象")
  @ApiImplicitParam(name = "id", value = "主键", required = true, dataType = "String")
  @GetMapping("/getId")
  public R getId(String id, String stationId) {
    EpPatrolMissed bean = epPatrolMissedService.getById(id);
    String resultId = bean.getResultId();
    List<EpPatrolPointResult> list = epPatrolPointResultService.getByResultId(resultId, stationId);
    list =
        list.stream()
            .filter(
                (epPatrolPointResult) -> {
                  return epPatrolPointResult.getPatrolStatus() == 0;
                })
            .collect(Collectors.toList());
    ArrayList<String> resultList = new ArrayList<>();
    for (EpPatrolPointResult epPatrolPointResult : list) {
      resultList.add(epPatrolPointResult.getPointId());
    }
    return R.ok().put("pointIdList", resultList);
  }

  /**
   * 根据条件导出漏检数据excel文件
   *
   * @param keywords 可能是计划名称 线路名称 巡查员姓名
   * @param stationId 站点id
   */
  @ApiOperation(value = "根据条件导出漏检数据excel文件", notes = "根据条件导出漏检数据excel文件")
  @GetMapping("/export")
  public void export( String keywords, String stationId, HttpServletRequest request, HttpServletResponse rep) {
    EpPatrolMissedModel model = new EpPatrolMissedModel();
    model.setStationId(stationId);
    model.setKeywords(keywords);
	// 获取到需要导出的数据
    List<EpPatrolMissed> epPatrolMissedList = (List<EpPatrolMissed>) ((MyPage) list(model).get("page")).getRows();

    OutputStream os = null;
    try {
      /** 取得输出流 */
      os = rep.getOutputStream();
      /** 清空输出流 */
      rep.reset();
      rep.setHeader("Access-Control-Expose-Headers", "Content-Disposition");
      String fileName = "漏检数据.xlsx";
      String userAgent = request.getHeader("USER-AGENT");
      if (userAgent.contains(Constants.FIREFOX)) {
        // 是火狐浏览器，使用BASE64编码
        fileName = "=?utf-8?b?" + new BASE64Encoder().encode(fileName.getBytes("utf-8")) + "?=";
      } else {
        // 给文件名进行URL编码
        // URLEncoder.encode()需要两个参数，第一个参数时要编码的字符串，第二个是编码所采用的字符集
        fileName = URLEncoder.encode(fileName, "utf-8");
      }
      rep.setHeader("Content-disposition", "attachment;fileName=" + fileName);
      /** 设定输出文件头,输出类型 */
      rep.setContentType("application/msexcel");
      DateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
      XSSFWorkbook workbook = new XSSFWorkbook();
      // 创建单元格样式
      XSSFCellStyle cellStyle = workbook.createCellStyle();
      cellStyle.setAlignment(HorizontalAlignment.CENTER);
      XSSFSheet sheet = workbook.createSheet("1");
      XSSFRow firstRow = sheet.createRow(0);
      firstRow.createCell(0).setCellValue("序号");
      firstRow.createCell(1).setCellValue("计划名称");
      firstRow.createCell(2).setCellValue("巡查线路");
      firstRow.createCell(3).setCellValue("巡查员");
      firstRow.createCell(4).setCellValue("巡查开始时间");
      firstRow.createCell(5).setCellValue("巡查结束时间");

      int index = 1;
      for (EpPatrolMissed epPatrolMissed : epPatrolMissedList) {
        String resultId = epPatrolMissed.getResultId();
        EpPatrolResult epPatrolResult = epPatrolResultService.getById(resultId);
        String planId = epPatrolResult.getPlanId();
        EpPatrolPlan plan = epPatrolPlanService.getById(planId);

        XSSFRow row = sheet.createRow(index);
        row.createCell(0).setCellValue(index);
        row.createCell(1).setCellValue(plan.getName());
        row.createCell(2).setCellValue(plan.getLineName());
        row.createCell(3).setCellValue(epPatrolMissed.getPatrollerName());
        row.createCell(4).setCellValue(sdf.format(epPatrolMissed.getStartTime()));
        row.createCell(5).setCellValue(sdf.format(epPatrolMissed.getEndTime()));
        index++;
      }
      // 设置单元格样式
      for (int i = 0; i < sheet.getPhysicalNumberOfRows(); i++) {
        XSSFRow row = sheet.getRow(i);
        for (int j = 0; j < row.getPhysicalNumberOfCells(); j++) {
          if (row.getCell(j) == null) {
            row.createCell(j).setCellStyle(cellStyle);
          } else {
            row.getCell(j).setCellStyle(cellStyle);
          }
        }
      }
      for (int i = 0; i < firstRow.getPhysicalNumberOfCells(); i++) {
        // 设置列宽自适应
        sheet.autoSizeColumn(i);
        sheet.setColumnWidth(i, sheet.getColumnWidth(i) * 17 / 10);
      }
      workbook.write(os);
      os.flush();

    } catch (Exception e) {
      e.printStackTrace();
    } finally {
      if (os != null) {
        try {
          os.close();
        } catch (IOException e) {
          e.printStackTrace();
        }
      }
    }
  }
}
