package com.devplatform.equipment.modules.eppatrolmissed.dao;

import com.devplatform.common.dao.MyBaseMapper;
import com.devplatform.equipment.modules.eppatrolmissed.bean.EpPatrolMissed;
import com.devplatform.equipment.modules.eppatrolmissed.model.EpPatrolMissedModel;
import java.util.List;
import org.apache.ibatis.annotations.Mapper;
import org.springframework.stereotype.Repository;

/**
 * EpPatrolMissed Mapper 用于电子巡查漏检数据表的数据库操作
 *
 * @author Administrator
 */
@Mapper
@Repository
public interface EpPatrolMissedDao extends MyBaseMapper<EpPatrolMissed> {

  /**
   * 查询漏检数量
   * @param model
   * @return
   */
  Integer queryPageByCount(EpPatrolMissedModel model);

  /**
   * 查询漏检数据
   * @param model
   * @return
   */
  List<EpPatrolMissed> queryPageByList(EpPatrolMissedModel model);
}
