package com.devplatform.equipment.modules.eppatrolplan.bean;

import com.alibaba.fastjson.JSON;
import com.devplatform.equipment.common.utils.SendEmail;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.lang.StringUtils;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
/**
 * @author Administrator
 */
public class SendMessage implements Job {

  @Override
  public void execute(JobExecutionContext context) throws JobExecutionException {
    JobDataMap jobDataMap = context.getJobDetail().getJobDataMap();
    String mail = (String) jobDataMap.get("mail");
    String plan = (String) jobDataMap.get("plan");
    StringBuilder sb = new StringBuilder();
    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    if (StringUtils.isNotBlank(plan)) {
      EpPatrolPlan epPatrolPlan = JSON.parseObject(plan, EpPatrolPlan.class);
      String name = epPatrolPlan.getName();
      Date startTime = epPatrolPlan.getStartTime();
      Date endTime = epPatrolPlan.getEndTime();
      String patrollerName = epPatrolPlan.getPatrollerName();
      sb.append(patrollerName)
          .append("你好，计划于")
          .append(sdf.format(startTime))
          .append(" - ")
          .append(sdf.format(endTime))
          .append("时间的 ")
          .append(name)
          .append(" 巡检任务即将开始，请您及时安排巡查任务。");

    } else {
      System.err.println("数据有误，发送邮件失败！");
    }
    //        XXX(巡检员)你好，计划于XXXX(开始时间)-XXXX(结束时间)时间的XXXX(计划名称)巡检任务即将开始，请您及时安排巡查任务。

    boolean b = SendEmail.sendEmail(mail, "", "巡查计划提醒", sb.toString());
    System.err.println(
        "给"
            + mail
            + "发送邮件"
            + (b ? "成功" : "失败")
            + "! "
            + new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
  }
}
